/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.HdrHistogram.DoubleHistogram;
import org.eclipse.collections.api.tuple.Pair;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.ImmutableGraphCreateFromStoreConfig;
import org.neo4j.gds.core.loading.CatalogRequest;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.impl.similarity.Computations;
import org.neo4j.gds.impl.similarity.SimilarityAlgorithm;
import org.neo4j.gds.impl.similarity.SimilarityAlgorithmResult;
import org.neo4j.gds.impl.similarity.SimilarityConfig;
import org.neo4j.gds.results.SimilarityResult;
import org.neo4j.gds.similarity.AlphaSimilarityStatsResult;
import org.neo4j.gds.similarity.AlphaSimilaritySummaryResult;
import org.neo4j.gds.similarity.SimilarityExporter;
import org.neo4j.gds.similarity.nil.NullGraphStore;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

abstract class AlphaSimilarityProc<ALGO extends SimilarityAlgorithm<ALGO, ?>, CONFIG extends SimilarityConfig>
extends AlgoBaseProc<ALGO, SimilarityAlgorithmResult, CONFIG> {
    public static final String SIMILARITY_FAKE_GRAPH_NAME = "  SIM-NULL-GRAPH";

    AlphaSimilarityProc() {
    }

    Stream<SimilarityResult> stream(Object graphNameOrConfig, Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult compute = this.compute(graphNameOrConfig, configuration);
        SimilarityAlgorithmResult result = (SimilarityAlgorithmResult)compute.result();
        assert (result != null);
        return result.stream();
    }

    Stream<AlphaSimilaritySummaryResult> write(Object graphNameOrConfig, Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult compute = this.compute(graphNameOrConfig, configuration);
        SimilarityConfig config = (SimilarityConfig)compute.config();
        SimilarityAlgorithmResult result = (SimilarityAlgorithmResult)compute.result();
        assert (result != null);
        if (result.isEmpty()) {
            return this.emptyStream(config.writeRelationshipType(), config.writeProperty());
        }
        return this.writeAndAggregateResults(result, config, ((SimilarityAlgorithm)compute.algorithm()).getTerminationFlag());
    }

    Stream<AlphaSimilarityStatsResult> stats(Object graphNameOrConfig, Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult compute = this.compute(graphNameOrConfig, configuration);
        SimilarityAlgorithmResult result = (SimilarityAlgorithmResult)compute.result();
        assert (result != null);
        if (result.isEmpty()) {
            return Stream.of(AlphaSimilarityStatsResult.from(0L, 0L, 0L, new AtomicLong(0L), -1L, new DoubleHistogram(5)));
        }
        AtomicLong similarityPairs = new AtomicLong();
        DoubleHistogram histogram = new DoubleHistogram(5);
        result.stream().forEach(recorder -> {
            recorder.record(histogram);
            similarityPairs.getAndIncrement();
        });
        return Stream.of(AlphaSimilarityStatsResult.from(result.nodes(), result.sourceIdsLength(), result.targetIdsLength(), similarityPairs, result.computations().map(Computations::count).orElse(-1L), histogram));
    }

    abstract ALGO newAlgo(CONFIG var1, AllocationTracker var2);

    abstract String taskName();

    protected final AlgorithmFactory<ALGO, CONFIG> algorithmFactory() {
        return new AlgorithmFactory<ALGO, CONFIG>(){

            protected String taskName() {
                return AlphaSimilarityProc.this.taskName();
            }

            protected ALGO build(Graph graph, CONFIG configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                AlphaSimilarityProc.this.removeGraph();
                return AlphaSimilarityProc.this.newAlgo(configuration, allocationTracker);
            }
        };
    }

    public Pair<CONFIG, Optional<String>> processInput(Object graphNameOrConfig, Map<String, Object> configuration) {
        if (graphNameOrConfig instanceof String) {
            throw new IllegalArgumentException("Similarity algorithms do not support named graphs");
        }
        if (graphNameOrConfig instanceof Map) {
            Map configMap = (Map)graphNameOrConfig;
            graphNameOrConfig = SIMILARITY_FAKE_GRAPH_NAME;
            configuration = configMap;
            configuration.remove("nodeQuery");
            configuration.remove("relationshipQuery");
            configuration.remove("nodeProjection");
            configuration.remove("relationshipProjection");
            GraphStoreCatalog.set((GraphCreateConfig)ImmutableGraphCreateFromStoreConfig.of((String)this.username(), (String)graphNameOrConfig.toString(), (NodeProjections)NodeProjections.ALL, (RelationshipProjections)RelationshipProjections.ALL), (GraphStore)new NullGraphStore(this.databaseId()));
        }
        try {
            return super.processInput(graphNameOrConfig, configuration);
        }
        catch (RuntimeException e) {
            this.removeGraph();
            throw e;
        }
    }

    private void removeGraph() {
        GraphStoreCatalog.remove((CatalogRequest)CatalogRequest.of((String)this.username(), (NamedDatabaseId)this.databaseId()), (String)SIMILARITY_FAKE_GRAPH_NAME, gsc -> {}, (boolean)true);
    }

    private Stream<AlphaSimilaritySummaryResult> emptyStream(String writeRelationshipType, String writeProperty) {
        return Stream.of(AlphaSimilaritySummaryResult.from(0L, 0L, 0L, new AtomicLong(0L), -1L, writeRelationshipType, writeProperty, new DoubleHistogram(5)));
    }

    private Stream<AlphaSimilaritySummaryResult> writeAndAggregateResults(SimilarityAlgorithmResult algoResult, CONFIG config, TerminationFlag terminationFlag) {
        AtomicLong similarityPairs = new AtomicLong();
        DoubleHistogram histogram = new DoubleHistogram(5);
        Consumer<SimilarityResult> recorder = result -> {
            result.record(histogram);
            similarityPairs.getAndIncrement();
        };
        SimilarityExporter similarityExporter = new SimilarityExporter(TransactionContext.of((GraphDatabaseAPI)this.api, (Transaction)this.procedureTransaction), config.writeRelationshipType(), config.writeProperty(), terminationFlag);
        similarityExporter.export(algoResult.stream().peek(recorder), config.writeBatchSize());
        return Stream.of(AlphaSimilaritySummaryResult.from(algoResult.nodes(), algoResult.sourceIdsLength(), algoResult.targetIdsLength(), similarityPairs, algoResult.computations().map(Computations::count).orElse(-1L), config.writeRelationshipType(), config.writeProperty(), histogram));
    }
}

