/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.procedureutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.ProcedureAndFunctionScanner;
import org.neo4j.gds.ProcedureRunner;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Procedure;

public final class ProcedureReflection {
    private final List<Method> procedureMethods = ProcedureAndFunctionScanner.streamMethodsContainingAnnotation(Procedure.class).collect(Collectors.toList());
    public static final ProcedureReflection INSTANCE = new ProcedureReflection();

    private ProcedureReflection() {
    }

    public Method findProcedureMethod(String procName) {
        List<Method> foundMethods = this.findProcedureMethodsByName(procName);
        if (foundMethods.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Invalid procedure name `%s` for pipelining.", (Object[])new Object[]{procName}));
        }
        if (foundMethods.size() > 1) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Ambiguous procedure name `%s`. Found matching procedures %s.", (Object[])new Object[]{procName, foundMethods.stream().map(this::procedureName).collect(Collectors.joining(", "))}));
        }
        return foundMethods.get(0);
    }

    private List<Method> findProcedureMethodsByName(String shortName) {
        return this.procedureMethods.stream().filter(method -> {
            if (!AlgoBaseProc.class.isAssignableFrom(method.getDeclaringClass())) {
                return false;
            }
            return ProcedureReflection.validShortName(this.procedureName((Method)method), shortName);
        }).collect(Collectors.toList());
    }

    private static boolean validShortName(String fullName, String shortName) {
        String normalizedFullName = "." + fullName;
        String normalizedShortName = "." + shortName + (shortName.endsWith(".mutate") ? "" : ".mutate");
        return normalizedFullName.endsWith(normalizedShortName);
    }

    public String procedureName(Method method) {
        Procedure annotation = method.getAnnotation(Procedure.class);
        return annotation.name().isEmpty() ? annotation.value() : annotation.name();
    }

    private AlgoBaseProc<?, ?, ?> createProcedure(BaseProc caller, Method method) {
        Class<?> procClass = method.getDeclaringClass();
        return (AlgoBaseProc)ProcedureRunner.instantiateProcedure((BaseProc)caller, procClass);
    }

    public Optional<AlgoBaseConfig> createAlgoConfig(BaseProc caller, Method procMethod, CypherMapWrapper config) {
        try {
            AlgoBaseProc<?, ?, ?> proc = this.createProcedure(caller, procMethod);
            Method newConfigMethod = proc.getClass().getDeclaredMethod("newConfig", String.class, Optional.class, Optional.class, CypherMapWrapper.class);
            newConfigMethod.setAccessible(true);
            return Optional.of((AlgoBaseConfig)newConfigMethod.invoke(proc, "", Optional.empty(), Optional.empty(), config));
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getTargetException().getMessage(), e.getTargetException().getCause());
        }
        catch (IllegalAccessException | NoSuchMethodException ignored) {
            return Optional.empty();
        }
    }

    public void invokeProc(BaseProc caller, String graphName, Method procMethod, Map<String, Object> config) {
        AlgoBaseProc<?, ?, ?> procedure = this.createProcedure(caller, procMethod);
        try {
            procMethod.invoke(procedure, graphName, config);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

