/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureExtractor;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionPredictor;
import org.neo4j.gds.similarity.knn.SimilarityComputer;

class LinkPredictionSimilarityComputer
implements SimilarityComputer {
    private final LinkFeatureExtractor linkFeatureExtractor;
    private final LinkLogisticRegressionPredictor predictor;
    private final Graph graph;

    LinkPredictionSimilarityComputer(LinkFeatureExtractor linkFeatureExtractor, LinkLogisticRegressionPredictor predictor, Graph graph) {
        this.linkFeatureExtractor = linkFeatureExtractor;
        this.predictor = predictor;
        this.graph = graph;
    }

    public double similarity(long sourceId, long targetId) {
        double[] features = this.linkFeatureExtractor.extractFeatures(sourceId, targetId);
        return this.predictor.predictedProbability(features);
    }

    public boolean excludeNodePair(long firstNodeId, long secondNodeId) {
        if (firstNodeId == secondNodeId) {
            return true;
        }
        return this.graph.exists(firstNodeId, secondNodeId);
    }

    public LinkPredictionSimilarityComputer concurrentCopy() {
        return new LinkPredictionSimilarityComputer(this.linkFeatureExtractor, this.predictor, this.graph.concurrentCopy());
    }
}

