/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.GraphCreateConfigValidations;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPrediction;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPipelineAlgorithmFactory;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPipelineStreamConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionPipelineStreamProc
extends AlgoBaseProc<LinkPrediction, LinkPredictionResult, LinkPredictionPipelineStreamConfig> {
    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.predict.stream", mode=Mode.READ)
    @Description(value="Predicts relationships for all node pairs based on a previously trained link prediction model.")
    public Stream<Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult result = this.compute(graphNameOrConfig, configuration);
        Graph graph = result.graph();
        if (result.isGraphEmpty()) {
            graph.release();
            return Stream.empty();
        }
        return ((LinkPredictionResult)result.result()).stream().map(predictedLink -> new Result(graph.toOriginalNodeId(predictedLink.sourceId()), graph.toOriginalNodeId(predictedLink.targetId()), predictedLink.probability()));
    }

    protected void validateConfigsBeforeLoad(GraphCreateConfig graphCreateConfig, LinkPredictionPipelineStreamConfig config) {
        GraphCreateConfigValidations.validateIsUndirectedGraph((GraphCreateConfig)graphCreateConfig, (AlgoBaseConfig)config);
    }

    protected LinkPredictionPipelineStreamConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return LinkPredictionPipelineStreamConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<LinkPrediction, LinkPredictionPipelineStreamConfig> algorithmFactory() {
        return new LinkPredictionPipelineAlgorithmFactory<LinkPredictionPipelineStreamConfig>((BaseProc)this, this.databaseId());
    }

    public static final class Result {
        public final long node1;
        public final long node2;
        public final double probability;

        public Result(long node1, long node2, double probability) {
            this.node1 = node1;
            this.node2 = node2;
            this.probability = probability;
        }
    }
}

