/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.ModelConfig;
import org.neo4j.gds.config.MutateRelationshipConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPipelineMutateConfig;

public final class LinkPredictionPipelineMutateConfigImpl
implements LinkPredictionPipelineMutateConfig {
    private String mutateProperty;
    private double sampleRate;
    private Optional<Integer> topN;
    private Optional<Double> threshold;
    private Optional<Integer> topK;
    private Optional<Double> deltaThreshold;
    private Optional<Integer> maxIterations;
    private Optional<Integer> randomJoins;
    private Optional<String> graphName;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    private Optional<GraphCreateConfig> implicitCreateConfig;
    private String username;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    private Optional<Long> randomSeed;
    private String modelName;
    private String mutateRelationshipType;

    public LinkPredictionPipelineMutateConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.mutateProperty = (String)CypherMapWrapper.failOnNull((String)"mutateProperty", (Object)config.getString("mutateProperty", LinkPredictionPipelineMutateConfig.super.mutateProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sampleRate = config.getDouble("sampleRate", LinkPredictionPipelineMutateConfig.super.sampleRate());
            CypherMapWrapper.validateDoubleRange((String)"sampleRate", (double)this.sampleRate, (double)0.0, (double)1.0, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.topN = (Optional)CypherMapWrapper.failOnNull((String)"topN", (Object)config.getOptional("topN", Integer.class));
            this.topN.ifPresent(topN -> CypherMapWrapper.validateIntegerRange((String)"topN", (int)topN, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.threshold = (Optional)CypherMapWrapper.failOnNull((String)"threshold", (Object)config.getOptional("threshold", Double.class));
            this.threshold.ifPresent(threshold -> CypherMapWrapper.validateDoubleRange((String)"threshold", (double)threshold, (double)0.0, (double)1.0, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.topK = (Optional)CypherMapWrapper.failOnNull((String)"topK", (Object)config.getOptional("topK", Integer.class));
            this.topK.ifPresent(topK -> CypherMapWrapper.validateIntegerRange((String)"topK", (int)topK, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.deltaThreshold = (Optional)CypherMapWrapper.failOnNull((String)"deltaThreshold", (Object)config.getOptional("deltaThreshold", Double.class));
            this.deltaThreshold.ifPresent(deltaThreshold -> CypherMapWrapper.validateDoubleRange((String)"deltaThreshold", (double)deltaThreshold, (double)0.0, (double)1.0, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxIterations = (Optional)CypherMapWrapper.failOnNull((String)"maxIterations", (Object)config.getOptional("maxIterations", Integer.class));
            this.maxIterations.ifPresent(maxIterations -> CypherMapWrapper.validateIntegerRange((String)"maxIterations", (int)maxIterations, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomJoins = (Optional)CypherMapWrapper.failOnNull((String)"randomJoins", (Object)config.getOptional("randomJoins", Integer.class));
            this.randomJoins.ifPresent(randomJoins -> CypherMapWrapper.validateIntegerRange((String)"randomJoins", (int)randomJoins, (int)0, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)LinkPredictionPipelineMutateConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)LinkPredictionPipelineMutateConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", LinkPredictionPipelineMutateConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", LinkPredictionPipelineMutateConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", LinkPredictionPipelineMutateConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapWrapper.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.modelName = (String)CypherMapWrapper.failOnNull((String)"modelName", (Object)ModelConfig.validateName((String)config.requireString("modelName")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.mutateRelationshipType = (String)CypherMapWrapper.failOnNull((String)"mutateRelationshipType", (Object)MutateRelationshipConfig.validateTypeIdentifier((String)config.requireString("mutateRelationshipType")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateParameterCombinations();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public String mutateProperty() {
        return this.mutateProperty;
    }

    @Override
    public double sampleRate() {
        return this.sampleRate;
    }

    @Override
    public Optional<Integer> topN() {
        return this.topN;
    }

    @Override
    public Optional<Double> threshold() {
        return this.threshold;
    }

    @Override
    public Optional<Integer> topK() {
        return this.topK;
    }

    @Override
    public Optional<Double> deltaThreshold() {
        return this.deltaThreshold;
    }

    @Override
    public Optional<Integer> maxIterations() {
        return this.maxIterations;
    }

    @Override
    public Optional<Integer> randomJoins() {
        return this.randomJoins;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("mutateProperty", "sampleRate", "topN", "threshold", "topK", "deltaThreshold", "maxIterations", "randomJoins", "relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "randomSeed", "modelName", "mutateRelationshipType");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("mutateProperty", this.mutateProperty());
        map.put("sampleRate", this.sampleRate());
        this.topN().ifPresent(topN -> map.put("topN", topN));
        this.threshold().ifPresent(threshold -> map.put("threshold", threshold));
        this.topK().ifPresent(topK -> map.put("topK", topK));
        this.deltaThreshold().ifPresent(deltaThreshold -> map.put("deltaThreshold", deltaThreshold));
        this.maxIterations().ifPresent(maxIterations -> map.put("maxIterations", maxIterations));
        this.randomJoins().ifPresent(randomJoins -> map.put("randomJoins", randomJoins));
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        map.put("modelName", this.modelName());
        map.put("mutateRelationshipType", this.mutateRelationshipType());
        return map;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }

    public String modelName() {
        return this.modelName;
    }

    public String mutateRelationshipType() {
        return this.mutateRelationshipType;
    }
}

