/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.Collection;
import java.util.Optional;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.ml.core.tensor.Matrix;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineExecutor;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureExtractor;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionData;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionPredictor;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionSimilarityComputer;

public abstract class LinkPrediction
extends Algorithm<LinkPrediction, LinkPredictionResult> {
    private final LinkLogisticRegressionData modelData;
    private final PipelineExecutor pipelineExecutor;
    private final Collection<NodeLabel> nodeLabels;
    private final Collection<RelationshipType> relationshipTypes;
    private final GraphStore graphStore;
    protected final int concurrency;

    LinkPrediction(LinkLogisticRegressionData modelData, PipelineExecutor pipelineExecutor, Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes, GraphStore graphStore, int concurrency, ProgressTracker progressTracker) {
        super(progressTracker);
        this.modelData = modelData;
        this.pipelineExecutor = pipelineExecutor;
        this.nodeLabels = nodeLabels;
        this.relationshipTypes = relationshipTypes;
        this.graphStore = graphStore;
        this.concurrency = concurrency;
    }

    public LinkPredictionResult compute() {
        this.progressTracker.beginSubTask("Link Prediction Pipeline");
        this.pipelineExecutor.executeNodePropertySteps(this.nodeLabels, this.relationshipTypes);
        this.assertRunning();
        LinkPredictionResult result = this.predict();
        this.pipelineExecutor.removeNodeProperties(this.graphStore, this.nodeLabels);
        this.progressTracker.endSubTask("Link Prediction Pipeline");
        return result;
    }

    private LinkPredictionResult predict() {
        this.progressTracker.beginSubTask();
        Graph graph = this.graphStore.getGraph(this.nodeLabels, this.relationshipTypes, Optional.empty());
        LinkFeatureExtractor featureExtractor = this.pipelineExecutor.linkFeatureExtractor(graph);
        assert (featureExtractor.featureDimension() == ((Matrix)this.modelData.weights().data()).totalSize()) : "Model must contain a weight for each feature.";
        LinkLogisticRegressionPredictor predictor = new LinkLogisticRegressionPredictor(this.modelData);
        LinkPredictionSimilarityComputer linkPredictionSimilarityComputer = new LinkPredictionSimilarityComputer(featureExtractor, predictor, graph);
        LinkPredictionResult result = this.predictLinks(graph, linkPredictionSimilarityComputer);
        this.progressTracker.endSubTask();
        return result;
    }

    abstract LinkPredictionResult predictLinks(Graph var1, LinkPredictionSimilarityComputer var2);

    public LinkPrediction me() {
        return this;
    }

    public void release() {
    }
}

