/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.TrainProc;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.GraphCreateConfigValidations;
import org.neo4j.gds.config.ModelConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.ml.MLTrainResult;
import org.neo4j.gds.ml.linkmodels.ImmutableLinkPredictionTrainConfig;
import org.neo4j.gds.ml.linkmodels.LinkPredictionModelInfo;
import org.neo4j.gds.ml.linkmodels.LinkPredictionTrain;
import org.neo4j.gds.ml.linkmodels.LinkPredictionTrainConfig;
import org.neo4j.gds.ml.linkmodels.LinkPredictionTrainFactory;
import org.neo4j.gds.ml.linkmodels.logisticregression.LinkLogisticRegressionData;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionTrainProc
extends TrainProc<LinkPredictionTrain, LinkLogisticRegressionData, LinkPredictionTrainConfig, LinkPredictionModelInfo> {
    @Procedure(name="gds.alpha.ml.linkPrediction.train", mode=Mode.READ)
    @Description(value="Trains a link prediction model")
    public Stream<MLTrainResult> train(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.trainAndStoreModelWithResult(graphNameOrConfig, configuration, (model, result) -> new MLTrainResult((Model<?, ?, ?>)model, result.computeMillis()));
    }

    @Procedure(name="gds.alpha.ml.linkPrediction.train.estimate", mode=Mode.READ)
    @Description(value="Estimates memory for training a link prediction model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected LinkPredictionTrainConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        LinkPredictionTrainConfig lpConfig = LinkPredictionTrainConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
        RelationshipType trainType = lpConfig.trainRelationshipType();
        RelationshipType testType = lpConfig.testRelationshipType();
        return ImmutableLinkPredictionTrainConfig.builder().from(lpConfig).relationshipTypes(List.of(trainType.name, testType.name)).relationshipWeightProperty("label").build();
    }

    protected String modelType() {
        return "Link Prediction";
    }

    protected void validateConfigsBeforeLoad(GraphCreateConfig graphCreateConfig, LinkPredictionTrainConfig config) {
        super.validateConfigsBeforeLoad(graphCreateConfig, (ModelConfig)config);
        GraphCreateConfigValidations.validateIsUndirectedGraph((GraphCreateConfig)graphCreateConfig, (AlgoBaseConfig)config);
        if (config.params().isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No model candidates (params) specified, we require at least one", (Object[])new Object[0]));
        }
    }

    protected AlgorithmFactory<LinkPredictionTrain, LinkPredictionTrainConfig> algorithmFactory() {
        return new LinkPredictionTrainFactory();
    }
}

