/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influence\u039caximization;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.impl.influenceMaximization.CELF;
import org.neo4j.gds.influence\u039caximization.InfluenceMaximizationConfig;
import org.neo4j.gds.influence\u039caximization.InfluenceMaximizationConfigImpl;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.InfluenceMaximizationResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class CELFProc
extends AlgoBaseProc<CELF, CELF, InfluenceMaximizationConfig> {
    private static final String DESCRIPTION = "The Cost Effective Lazy Forward (CELF) algorithm aims to find k nodes that maximize the expected spread of influence in the network.";

    @Procedure(name="gds.alpha.influenceMaximization.celf.stream", mode=Mode.READ)
    @Description(value="The Cost Effective Lazy Forward (CELF) algorithm aims to find k nodes that maximize the expected spread of influence in the network.")
    public Stream<InfluenceMaximizationResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        if (computationResult.graph().isEmpty()) {
            computationResult.graph().release();
            return Stream.empty();
        }
        computationResult.graph().release();
        return ((CELF)computationResult.algorithm()).resultStream();
    }

    @Description(value="The Cost Effective Lazy Forward (CELF) algorithm aims to find k nodes that maximize the expected spread of influence in the network.")
    public Stream<InfluenceMaximizationResult.Stats> stats(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        InfluenceMaximizationConfig config = (InfluenceMaximizationConfig)computationResult.config();
        Graph graph = computationResult.graph();
        AbstractResultBuilder builder = new InfluenceMaximizationResult.Stats.Builder().withNodeCount(graph.nodeCount()).withConfig((AlgoBaseConfig)config).withComputeMillis(computationResult.computeMillis());
        return Stream.of((InfluenceMaximizationResult.Stats)builder.build());
    }

    protected InfluenceMaximizationConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return new InfluenceMaximizationConfigImpl(graphName, maybeImplicitCreate, username, config);
    }

    protected AlgorithmFactory<CELF, InfluenceMaximizationConfig> algorithmFactory() {
        return new AlgorithmFactory<CELF, InfluenceMaximizationConfig>(){

            protected String taskName() {
                return "CELF";
            }

            protected CELF build(Graph graph, InfluenceMaximizationConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                return new CELF(graph, configuration.seedSetSize(), configuration.propagationProbability(), configuration.monteCarloSimulations(), Pools.DEFAULT, configuration.concurrency(), allocationTracker);
            }
        };
    }
}

