/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.NodePropertiesWriter;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMapping;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.RelationshipProperties;
import org.neo4j.gds.api.nodeproperties.DoubleNodeProperties;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.impl.spanningTrees.KSpanningTree;
import org.neo4j.gds.impl.spanningTrees.Prim;
import org.neo4j.gds.impl.spanningTrees.SpanningTree;
import org.neo4j.gds.spanningtree.KSpanningTreeConfig;
import org.neo4j.gds.utils.InputNodeValidator;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class KSpanningTreeProc
extends NodePropertiesWriter<KSpanningTree, SpanningTree, KSpanningTreeConfig> {
    private static final String MAX_DESCRIPTION = "The maximum weight spanning tree (MST) starts from a given node, and finds all its reachable nodes and the set of relationships that connect the nodes together with the maximum possible weight.";
    private static final String MIN_DESCRIPTION = "The minimum weight spanning tree (MST) starts from a given node, and finds all its reachable nodes and the set of relationships that connect the nodes together with the minimum possible weight.";
    static DoubleUnaryOperator minMax;
    public static final String DEFAULT_CLUSTER_PROPERTY = "partition";

    @Procedure(value="gds.alpha.spanningTree.kmax.write", mode=Mode.WRITE)
    @Description(value="The maximum weight spanning tree (MST) starts from a given node, and finds all its reachable nodes and the set of relationships that connect the nodes together with the maximum possible weight.")
    public Stream<Prim.Result> kmax(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        minMax = Prim.MAX_OPERATOR;
        return this.computeAndWrite(graphNameOrConfig, configuration);
    }

    @Procedure(value="gds.alpha.spanningTree.kmin.write", mode=Mode.WRITE)
    @Description(value="The minimum weight spanning tree (MST) starts from a given node, and finds all its reachable nodes and the set of relationships that connect the nodes together with the minimum possible weight.")
    public Stream<Prim.Result> kmin(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        minMax = Prim.MIN_OPERATOR;
        return this.computeAndWrite(graphNameOrConfig, configuration);
    }

    public Stream<Prim.Result> computeAndWrite(Object graphNameOrConfig, Map<String, Object> configuration) {
        final AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        Graph graph = computationResult.graph();
        final SpanningTree spanningTree = (SpanningTree)computationResult.result();
        KSpanningTreeConfig config = (KSpanningTreeConfig)computationResult.config();
        Prim.Builder builder = new Prim.Builder();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of(builder.build());
        }
        builder.withEffectiveNodeCount(spanningTree.effectiveNodeCount);
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((Prim.Builder)builder).withWriteMillis(arg_0));){
            TaskProgressTracker progressTracker = new TaskProgressTracker(NodePropertyExporter.baseTask((String)"KSpanningTree", (long)graph.nodeCount()), this.log, config.writeConcurrency(), this.taskRegistryFactory);
            NodePropertyExporter exporter = this.nodePropertyExporterBuilder.withIdMapping((IdMapping)graph).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)this.transaction)).withProgressTracker((ProgressTracker)progressTracker).parallel(Pools.DEFAULT, config.writeConcurrency()).build();
            DoubleNodeProperties properties = new DoubleNodeProperties(){

                public long size() {
                    return computationResult.graph().nodeCount();
                }

                public double doubleValue(long nodeId) {
                    return spanningTree.head((int)nodeId);
                }
            };
            exporter.write(config.writeProperty(), (NodeProperties)properties);
            builder.withNodePropertiesWritten(exporter.propertiesWritten());
        }
        builder.withComputeMillis(computationResult.computeMillis());
        builder.withCreateMillis(computationResult.createMillis());
        return Stream.of(builder.build());
    }

    protected KSpanningTreeConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return KSpanningTreeConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<KSpanningTree, KSpanningTreeConfig> algorithmFactory() {
        return new AlgorithmFactory<KSpanningTree, KSpanningTreeConfig>(){

            protected String taskName() {
                return "KSpanningTree";
            }

            protected Task progressTask(Graph graph, KSpanningTreeConfig config) {
                return Tasks.task((String)this.taskName(), (Task)Tasks.leaf((String)"SpanningTree", (long)graph.nodeCount()), (Task[])new Task[]{Tasks.leaf((String)"Add relationship weights"), Tasks.leaf((String)"Remove relationships")});
            }

            protected KSpanningTree build(Graph graph, KSpanningTreeConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                InputNodeValidator.validateStartNode(configuration.startNodeId(), graph);
                return new KSpanningTree((IdMapping)graph, graph, (RelationshipProperties)graph, minMax, configuration.startNodeId(), configuration.k(), progressTracker);
            }
        };
    }
}

