/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.neo4j.gds.core.TransactionContext;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.results.SimilarityResult;
import org.neo4j.gds.utils.ExceptionUtil;
import org.neo4j.gds.utils.StatementApi;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class SimilarityExporter
extends StatementApi {
    private final int propertyId;
    private final int relationshipTypeId;
    private final TerminationFlag terminationFlag;

    public SimilarityExporter(TransactionContext tx, String relationshipType, String propertyName, TerminationFlag terminationFlag) {
        super(tx);
        this.propertyId = this.getOrCreatePropertyId(propertyName);
        this.relationshipTypeId = this.getOrCreateRelationshipId(relationshipType);
        this.terminationFlag = terminationFlag;
    }

    public void export(Stream<SimilarityResult> similarityPairs, long batchSize) {
        this.writeSequential(similarityPairs, batchSize);
    }

    private void export(SimilarityResult similarityResult) {
        this.applyInTransaction(statement -> {
            try {
                this.createRelationship(similarityResult, statement);
            }
            catch (Exception e) {
                ExceptionUtil.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    private void export(List<SimilarityResult> similarityResults) {
        this.applyInTransaction(statement -> {
            this.terminationFlag.assertRunning();
            long progress = 0L;
            for (SimilarityResult similarityResult : similarityResults) {
                try {
                    this.createRelationship(similarityResult, statement);
                    if (++progress % (long)Math.min(10000, Math.max(similarityResults.size() / 2, 1)) != 0L) continue;
                    this.terminationFlag.assertRunning();
                }
                catch (Exception e) {
                    ExceptionUtil.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            return null;
        });
    }

    private void createRelationship(SimilarityResult similarityResult, KernelTransaction statement) throws Exception {
        long node1 = similarityResult.item1;
        long node2 = similarityResult.item2;
        long relationshipId = statement.dataWrite().relationshipCreate(node1, this.relationshipTypeId, node2);
        statement.dataWrite().relationshipSetProperty(relationshipId, this.propertyId, (Value)Values.doubleValue((double)similarityResult.similarity));
    }

    private int getOrCreateRelationshipId(String relationshipType) {
        return (Integer)this.applyInTransaction(stmt -> stmt.tokenWrite().relationshipTypeGetOrCreateForName(relationshipType));
    }

    private int getOrCreatePropertyId(String propertyName) {
        return (Integer)this.applyInTransaction(stmt -> stmt.tokenWrite().propertyKeyGetOrCreateForName(propertyName));
    }

    private void writeSequential(Stream<SimilarityResult> similarityPairs, long batchSize) {
        if (batchSize == 1L) {
            similarityPairs.forEach(this::export);
        } else {
            Iterator iterator = similarityPairs.iterator();
            do {
                ParallelUtil.run(() -> this.export(SimilarityExporter.take(iterator, Math.toIntExact(batchSize))), (ExecutorService)Pools.DEFAULT_SINGLE_THREAD_POOL);
            } while (iterator.hasNext());
        }
    }

    private static List<SimilarityResult> take(Iterator<SimilarityResult> iterator, int batchSize) {
        ArrayList<SimilarityResult> result = new ArrayList<SimilarityResult>(batchSize);
        while (iterator.hasNext() && batchSize-- > 0) {
            result.add(iterator.next());
        }
        return result;
    }
}

