/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.impl.similarity.OverlapAlgorithm;
import org.neo4j.gds.impl.similarity.OverlapConfig;
import org.neo4j.gds.impl.similarity.OverlapConfigImpl;
import org.neo4j.gds.impl.similarity.SimilarityConfig;
import org.neo4j.gds.results.SimilarityResult;
import org.neo4j.gds.similarity.AlphaSimilarityProc;
import org.neo4j.gds.similarity.AlphaSimilarityStatsResult;
import org.neo4j.gds.similarity.AlphaSimilaritySummaryResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class OverlapProc
extends AlphaSimilarityProc<OverlapAlgorithm, OverlapConfig> {
    private static final String DESCRIPTION = "Overlap-similarity is an algorithm for finding similar nodes based on the overlap coefficient.";

    @Procedure(name="gds.alpha.similarity.overlap.stream", mode=Mode.READ)
    @Description(value="Overlap-similarity is an algorithm for finding similar nodes based on the overlap coefficient.")
    public Stream<SimilarityResult> overlapStream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.overlap.write", mode=Mode.WRITE)
    @Description(value="Overlap-similarity is an algorithm for finding similar nodes based on the overlap coefficient.")
    public Stream<AlphaSimilaritySummaryResult> overlapWrite(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.overlap.stats", mode=Mode.READ)
    @Description(value="Overlap-similarity is an algorithm for finding similar nodes based on the overlap coefficient.")
    public Stream<AlphaSimilarityStatsResult> overlapStats(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats(graphNameOrConfig, configuration);
    }

    protected OverlapConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper userInput) {
        return new OverlapConfigImpl(graphName, maybeImplicitCreate, username, userInput);
    }

    @Override
    OverlapAlgorithm newAlgo(OverlapConfig config, AllocationTracker allocationTracker) {
        return new OverlapAlgorithm((SimilarityConfig)config, this.api);
    }

    @Override
    String taskName() {
        return "Overlap-similarity";
    }
}

