/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.shortestpaths;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.impl.msbfs.AllShortestPathsStream;
import org.neo4j.gds.impl.msbfs.MSBFSASPAlgorithm;
import org.neo4j.gds.impl.msbfs.MSBFSAllShortestPaths;
import org.neo4j.gds.impl.msbfs.WeightedAllShortestPaths;
import org.neo4j.gds.shortestpaths.AllShortestPathsConfig;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class AllShortestPathsProc
extends AlgoBaseProc<MSBFSASPAlgorithm, Stream<AllShortestPathsStream.Result>, AllShortestPathsConfig> {
    private static final String DESCRIPTION = "The All Pairs Shortest Path (APSP) calculates the shortest (weighted) path between all pairs of nodes.";

    @Procedure(name="gds.alpha.allShortestPaths.stream", mode=Mode.READ)
    @Description(value="The All Pairs Shortest Path (APSP) calculates the shortest (weighted) path between all pairs of nodes.")
    public Stream<AllShortestPathsStream.Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration, false, false);
        if (computationResult.isGraphEmpty()) {
            computationResult.graph().release();
            return Stream.empty();
        }
        return (Stream)computationResult.result();
    }

    protected AllShortestPathsConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return AllShortestPathsConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<MSBFSASPAlgorithm, AllShortestPathsConfig> algorithmFactory() {
        return new AlgorithmFactory<MSBFSASPAlgorithm, AllShortestPathsConfig>(){

            protected String taskName() {
                return "MSBFSASPAlgorithm";
            }

            protected MSBFSASPAlgorithm build(Graph graph, AllShortestPathsConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                if (configuration.hasRelationshipWeightProperty()) {
                    return (MSBFSASPAlgorithm)new WeightedAllShortestPaths(graph, Pools.DEFAULT, configuration.concurrency()).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)AllShortestPathsProc.this.transaction));
                }
                return (MSBFSASPAlgorithm)new MSBFSAllShortestPaths(graph, allocationTracker, configuration.concurrency(), Pools.DEFAULT).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)AllShortestPathsProc.this.transaction));
            }
        };
    }
}

