/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.Optional;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.stream.StreamSupport;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.beta.pregel.Messages;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelProcedureConfig;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.beta.pregel.annotation.PregelProcedure;
import org.neo4j.gds.beta.pregel.context.ComputeContext;
import org.neo4j.gds.beta.pregel.context.InitContext;
import org.neo4j.gds.beta.pregel.context.MasterComputeContext;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.StringIdentifierValidations;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.pregel.HitsConfigImpl;

@PregelProcedure(name="gds.alpha.hits", description="Hyperlink-Induced Topic Search (HITS) is a link analysis algorithm that rates nodes")
public class Hits
implements PregelComputation<HitsConfig> {
    private static final String NEIGHBOR_IDS = "neighborIds";
    private final DoubleAdder globalNorm = new DoubleAdder();
    private HitsState state = HitsState.SEND_IDS;

    public PregelSchema schema(HitsConfig config) {
        return new PregelSchema.Builder().add(config.authProperty(), ValueType.DOUBLE).add(config.hubProperty(), ValueType.DOUBLE).add(NEIGHBOR_IDS, ValueType.LONG_ARRAY, PregelSchema.Visibility.PRIVATE).build();
    }

    public void init(InitContext<HitsConfig> context) {
        context.setNodeValue(((HitsConfig)context.config()).authProperty(), 1.0);
        context.setNodeValue(((HitsConfig)context.config()).hubProperty(), 1.0);
    }

    public void compute(ComputeContext<HitsConfig> context, Messages messages) {
        switch (this.state) {
            case SEND_IDS: {
                context.sendToNeighbors((double)context.nodeId());
                break;
            }
            case RECEIVE_IDS: {
                this.receiveIds(context, messages);
                break;
            }
            case CALCULATE_AUTHS: {
                this.calculateValue(context, messages, ((HitsConfig)context.config()).authProperty());
                break;
            }
            case NORMALIZE_AUTHS: {
                this.normalizeAuthValue(context);
                break;
            }
            case CALCULATE_HUBS: {
                this.calculateValue(context, messages, ((HitsConfig)context.config()).hubProperty());
                break;
            }
            case NORMALIZE_HUBS: {
                this.normalizeHubValue(context);
            }
        }
    }

    public boolean masterCompute(MasterComputeContext<HitsConfig> context) {
        if (this.state == HitsState.RECEIVE_IDS || this.state == HitsState.CALCULATE_AUTHS || this.state == HitsState.CALCULATE_HUBS) {
            double norm = this.globalNorm.sumThenReset();
            this.globalNorm.add(Math.sqrt(norm));
        } else if (this.state == HitsState.NORMALIZE_AUTHS || this.state == HitsState.NORMALIZE_HUBS) {
            this.globalNorm.reset();
        }
        this.state = this.state.advance();
        return false;
    }

    private void receiveIds(ComputeContext<HitsConfig> context, Messages messages) {
        long[] neighborIds = StreamSupport.stream(messages.spliterator(), false).mapToLong(Double::longValue).toArray();
        context.setNodeValue(NEIGHBOR_IDS, neighborIds);
        int auth = neighborIds.length;
        context.setNodeValue(((HitsConfig)context.config()).authProperty(), (double)auth);
        this.updateGlobalNorm(auth);
    }

    private void calculateValue(ComputeContext<HitsConfig> context, Messages messages, String authProperty) {
        double auth = 0.0;
        for (Double message : messages) {
            auth += message.doubleValue();
        }
        context.setNodeValue(authProperty, auth);
        this.updateGlobalNorm(auth);
    }

    private void normalizeHubValue(ComputeContext<HitsConfig> context) {
        double normalizedValue = this.normalize(context, ((HitsConfig)context.config()).hubProperty());
        context.sendToNeighbors(normalizedValue);
    }

    private void normalizeAuthValue(ComputeContext<HitsConfig> context) {
        double normalizedValue = this.normalize(context, ((HitsConfig)context.config()).authProperty());
        for (long neighbor : context.longArrayNodeValue(NEIGHBOR_IDS)) {
            context.sendTo(neighbor, normalizedValue);
        }
    }

    private void updateGlobalNorm(double value) {
        this.globalNorm.add(Math.pow(value, 2.0));
    }

    private double normalize(ComputeContext<HitsConfig> context, String property) {
        double value = context.doubleNodeValue(property);
        double norm = this.globalNorm.sum();
        double normalizedValue = value / norm;
        context.setNodeValue(property, normalizedValue);
        return normalizedValue;
    }

    private static enum HitsState {
        SEND_IDS{

            @Override
            HitsState advance() {
                return RECEIVE_IDS;
            }
        }
        ,
        RECEIVE_IDS{

            @Override
            HitsState advance() {
                return NORMALIZE_AUTHS;
            }
        }
        ,
        CALCULATE_AUTHS{

            @Override
            HitsState advance() {
                return NORMALIZE_AUTHS;
            }
        }
        ,
        NORMALIZE_AUTHS{

            @Override
            HitsState advance() {
                return CALCULATE_HUBS;
            }
        }
        ,
        CALCULATE_HUBS{

            @Override
            public HitsState advance() {
                return NORMALIZE_HUBS;
            }
        }
        ,
        NORMALIZE_HUBS{

            @Override
            HitsState advance() {
                return CALCULATE_AUTHS;
            }
        };


        abstract HitsState advance();
    }

    @ValueClass
    @Configuration
    public static interface HitsConfig
    extends PregelProcedureConfig {
        public int hitsIterations();

        @Value.Derived
        @Configuration.Ignore
        default public int maxIterations() {
            return this.hitsIterations() * 4 + 1;
        }

        @Configuration.Ignore
        @Value.Derived
        default public boolean isAsynchronous() {
            return false;
        }

        @Value.Default
        @Configuration.ConvertWith(value="validateHubProperty")
        default public String hubProperty() {
            return "hub";
        }

        @Value.Default
        @Configuration.ConvertWith(value="validateAuthProperty")
        default public String authProperty() {
            return "auth";
        }

        @Nullable
        public static String validateHubProperty(String input) {
            return StringIdentifierValidations.validateNoWhiteCharacter((String)input, (String)"hubProperty");
        }

        @Nullable
        public static String validateAuthProperty(String input) {
            return StringIdentifierValidations.validateNoWhiteCharacter((String)input, (String)"authProperty");
        }

        public static HitsConfig of(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitConfig, CypherMapWrapper userConfig) {
            return new HitsConfigImpl(graphName, maybeImplicitConfig, username, userConfig);
        }
    }
}

