/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.GraphStoreValidation;
import org.neo4j.gds.TrainProc;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.ml.MLTrainResult;
import org.neo4j.gds.ml.nodemodels.NodeClassificationModelInfo;
import org.neo4j.gds.ml.nodemodels.NodeClassificationTrain;
import org.neo4j.gds.ml.nodemodels.NodeClassificationTrainAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.NodeClassificationTrainConfig;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionData;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationTrainProc
extends TrainProc<NodeClassificationTrain, NodeLogisticRegressionData, NodeClassificationTrainConfig, NodeClassificationModelInfo> {
    @Procedure(name="gds.alpha.ml.nodeClassification.train", mode=Mode.READ)
    @Description(value="Trains a node classification model")
    public Stream<MLTrainResult> train(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.trainAndStoreModelWithResult(graphNameOrConfig, configuration, (model, result) -> new MLTrainResult((Model<?, ?, ?>)model, result.computeMillis()));
    }

    @Procedure(name="gds.alpha.ml.nodeClassification.train.estimate", mode=Mode.READ)
    @Description(value="Trains a node classification model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected String modelType() {
        return "nodeLogisticRegression";
    }

    protected void validateConfigsAfterLoad(GraphStore graphStore, GraphCreateConfig graphCreateConfig, NodeClassificationTrainConfig config) {
        super.validateConfigsAfterLoad(graphStore, graphCreateConfig, (AlgoBaseConfig)config);
        Collection filterLabels = config.nodeLabelIdentifiers(graphStore);
        if (!graphStore.hasNodeProperty(filterLabels, config.targetProperty())) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"`%s`: `%s` not found in graph with node properties: %s", (Object[])new Object[]{"targetProperty", config.targetProperty(), StringJoining.join((Collection)graphStore.nodePropertyKeys(filterLabels))}));
        }
        GraphStoreValidation.validate((GraphStore)graphStore, (AlgoBaseConfig)config);
    }

    protected NodeClassificationTrainConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return NodeClassificationTrainConfig.of(graphName, maybeImplicitCreate, (String)username, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<NodeClassificationTrain, NodeClassificationTrainConfig> algorithmFactory() {
        return new NodeClassificationTrainAlgorithmFactory();
    }
}

