/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.Map;
import java.util.Optional;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.MutateProc;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.IdMapping;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.GraphCreateConfigValidations;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPrediction;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPipelineAlgorithmFactory;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPipelineMutateConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.storable.NumberType;

public class LinkPredictionPipelineMutateProc
extends MutateProc<LinkPrediction, LinkPredictionResult, MutateResult, LinkPredictionPipelineMutateConfig> {
    static final String DESCRIPTION = "Predicts relationships for all non-connected node pairs based on a previously trained Link prediction pipeline.";

    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.predict.mutate", mode=Mode.READ)
    @Description(value="Predicts relationships for all non-connected node pairs based on a previously trained Link prediction pipeline.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphNameOrConfig, configuration));
    }

    protected void validateConfigsBeforeLoad(GraphCreateConfig graphCreateConfig, LinkPredictionPipelineMutateConfig config) {
        super.validateConfigsBeforeLoad(graphCreateConfig, (AlgoBaseConfig)config);
        GraphCreateConfigValidations.validateIsUndirectedGraph((GraphCreateConfig)graphCreateConfig, (AlgoBaseConfig)config);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(AlgoBaseProc.ComputationResult<LinkPrediction, LinkPredictionResult, LinkPredictionPipelineMutateConfig> computeResult) {
        return new MutateResult.Builder();
    }

    protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, AlgoBaseProc.ComputationResult<LinkPrediction, LinkPredictionResult, LinkPredictionPipelineMutateConfig> computationResult) {
        int concurrency = ((LinkPredictionPipelineMutateConfig)computationResult.config()).concurrency();
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().aggregation(Aggregation.SINGLE).nodes((IdMapping)computationResult.graph()).orientation(Orientation.UNDIRECTED).addPropertyConfig(Aggregation.NONE, DefaultValue.forDouble()).concurrency(concurrency).executorService(Pools.DEFAULT).allocationTracker(this.allocationTracker()).build();
        ParallelUtil.parallelStreamConsume((BaseStream)((LinkPredictionResult)computationResult.result()).stream(), (int)concurrency, stream -> stream.forEach(predictedLink -> relationshipsBuilder.addFromInternal(predictedLink.sourceId(), predictedLink.targetId(), predictedLink.probability())));
        Relationships relationships = relationshipsBuilder.build();
        LinkPredictionPipelineMutateConfig config = (LinkPredictionPipelineMutateConfig)computationResult.config();
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withMutateMillis(arg_0));){
            computationResult.graphStore().addRelationshipType(RelationshipType.of((String)config.mutateRelationshipType()), Optional.of(config.mutateProperty()), Optional.of(NumberType.FLOATING_POINT), relationships);
        }
        resultBuilder.withRelationshipsWritten(relationships.topology().elementCount());
    }

    protected LinkPredictionPipelineMutateConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return LinkPredictionPipelineMutateConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<LinkPrediction, LinkPredictionPipelineMutateConfig> algorithmFactory() {
        return new LinkPredictionPipelineAlgorithmFactory<LinkPredictionPipelineMutateConfig>((BaseProc)this, this.databaseId());
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long relationshipsWritten;

        MutateResult(long createMillis, long computeMillis, long mutateMillis, long relationshipsWritten, Map<String, Object> configuration) {
            super(createMillis, computeMillis, 0L, mutateMillis, configuration);
            this.relationshipsWritten = relationshipsWritten;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.createMillis, this.computeMillis, this.mutateMillis, this.relationshipsWritten, this.config.toMap());
            }
        }
    }
}

