/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionModelInfo;
import org.neo4j.gds.ml.linkmodels.pipeline.TrainingPipeline;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionData;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrainConfig;
import org.neo4j.gds.utils.StringFormatting;

public final class PipelineUtils {
    private PipelineUtils() {
    }

    public static TrainingPipeline getPipelineModelInfo(String pipelineName, String username) {
        Model model = ModelCatalog.getUntyped((String)username, (String)pipelineName);
        assert (model != null);
        if (!model.algoType().equals("Link prediction training pipeline")) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Steps can only be added to a model of type `%s`. But model `%s` is of type `%s`.", (Object[])new Object[]{"Link prediction training pipeline", pipelineName, model.algoType()}));
        }
        assert (model.customInfo() instanceof TrainingPipeline);
        return (TrainingPipeline)model.customInfo();
    }

    public static Model<LinkLogisticRegressionData, LinkPredictionTrainConfig, LinkPredictionModelInfo> getLinkPredictionPipeline(String pipelineName, String username) {
        return ModelCatalog.get((String)username, (String)pipelineName, LinkLogisticRegressionData.class, LinkPredictionTrainConfig.class, LinkPredictionModelInfo.class);
    }
}

