/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.ml.linkmodels.pipeline.procedureutils.ProcedureReflection;

public class NodePropertyStep
implements Model.Mappable {
    public final Method procMethod;
    public final Map<String, Object> config;

    private NodePropertyStep(Method procMethod, Map<String, Object> config) {
        this.procMethod = procMethod;
        this.config = config;
    }

    public static NodePropertyStep of(String procName, Map<String, Object> config) {
        Method procedureMethod = ProcedureReflection.INSTANCE.findProcedureMethod(procName);
        return new NodePropertyStep(procedureMethod, config);
    }

    public void execute(BaseProc caller, String graphName, Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relTypes) {
        HashMap<String, Object> configCopy = new HashMap<String, Object>(this.config);
        List nodeLabelStrings = nodeLabels.stream().map(ElementIdentifier::name).collect(Collectors.toList());
        List relTypeStrings = relTypes.stream().map(ElementIdentifier::name).collect(Collectors.toList());
        configCopy.put("nodeLabels", nodeLabelStrings);
        configCopy.put("relationshipTypes", relTypeStrings);
        this.execute(caller, graphName, configCopy);
    }

    private void execute(BaseProc caller, String graphName, Map<String, Object> config) {
        ProcedureReflection.INSTANCE.invokeProc(caller, graphName, this.procMethod, config);
    }

    public Map<String, Object> toMap() {
        return Map.of("name", ProcedureReflection.INSTANCE.procedureName(this.procMethod), "config", this.config);
    }
}

