/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ModelConfig;
import org.neo4j.gds.config.StringIdentifierValidations;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.linkmodels.pipeline.ImmutablePipelineDummyTrainConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.linkmodels.pipeline.TrainingPipeline;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionPipelineCreateProc
extends BaseProc {
    public static final String PIPELINE_MODEL_TYPE = "Link prediction training pipeline";

    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.create", mode=Mode.READ)
    @Description(value="Creates a link prediction pipeline in the model catalog.")
    public Stream<PipelineInfoResult> create(@Name(value="pipelineName") String input) {
        String pipelineName = StringIdentifierValidations.validateNoWhiteCharacter((String)input, (String)"pipelineName");
        Model model = Model.of((String)this.username(), (String)pipelineName, (String)PIPELINE_MODEL_TYPE, (GraphSchema)GraphSchema.empty(), (Object)new Object(), (ModelConfig)PipelineDummyTrainConfig.of(this.username()), (Model.Mappable)new TrainingPipeline());
        ModelCatalog.set((Model)model);
        return Stream.of(new PipelineInfoResult(pipelineName, (TrainingPipeline)model.customInfo()));
    }

    @ValueClass
    @Configuration
    public static interface PipelineDummyTrainConfig
    extends BaseConfig,
    ModelConfig {
        public static PipelineDummyTrainConfig of(String username) {
            return ImmutablePipelineDummyTrainConfig.of(username, "");
        }
    }
}

