/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionSplitConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineUtils;
import org.neo4j.gds.ml.linkmodels.pipeline.TrainingPipeline;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionPipelineConfigureSplitProc
extends BaseProc {
    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.configureSplit", mode=Mode.READ)
    @Description(value="Configures the split of the link prediction pipeline.")
    public Stream<PipelineInfoResult> configureSplit(@Name(value="pipelineName") String pipelineName, @Name(value="configuration") Map<String, Object> configMap) {
        TrainingPipeline pipeline = PipelineUtils.getPipelineModelInfo(pipelineName, this.username());
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configMap);
        LinkPredictionSplitConfig config = LinkPredictionSplitConfig.of(cypherConfig);
        cypherConfig.requireOnlyKeysFrom(config.configKeys());
        pipeline.setSplitConfig(config);
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }
}

