/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.linkmodels.pipeline.NodePropertyStep;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineUtils;
import org.neo4j.gds.ml.linkmodels.pipeline.TrainingPipeline;
import org.neo4j.gds.ml.linkmodels.pipeline.procedureutils.ProcedureReflection;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionPipelineAddStepProcs
extends BaseProc {
    private static final List<String> reservedConfigKeys = List.of("nodeLabels", "relationshipTypes");

    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.addNodeProperty", mode=Mode.READ)
    @Description(value="Add a node property step to an existing link prediction pipeline.")
    public Stream<PipelineInfoResult> addNodeProperty(@Name(value="pipelineName") String pipelineName, @Name(value="procedureName") String taskName, @Name(value="procedureConfiguration") Map<String, Object> procedureConfig) {
        TrainingPipeline pipeline = PipelineUtils.getPipelineModelInfo(pipelineName, this.username());
        if (reservedConfigKeys.stream().anyMatch(procedureConfig::containsKey)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot configure %s for an individual node property step, but can only be configured at `train` and `predict` mode.", (Object[])new Object[]{StringJoining.join(reservedConfigKeys)}));
        }
        CypherMapWrapper wrappedConfig = CypherMapWrapper.create(procedureConfig);
        Method procedureMethod = ProcedureReflection.INSTANCE.findProcedureMethod(taskName);
        Optional<AlgoBaseConfig> typedConfig = ProcedureReflection.INSTANCE.createAlgoConfig(this, procedureMethod, wrappedConfig);
        typedConfig.ifPresent(config -> wrappedConfig.requireOnlyKeysFrom(config.configKeys()));
        NodePropertyStep step = NodePropertyStep.of(taskName, procedureConfig);
        pipeline.addNodePropertyStep(step);
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }

    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.addFeature", mode=Mode.READ)
    @Description(value="Add a feature step to an existing link prediction pipeline.")
    public Stream<PipelineInfoResult> addFeature(@Name(value="pipelineName") String pipelineName, @Name(value="featureType") String featureType, @Name(value="configuration") Map<String, Object> config) {
        TrainingPipeline pipeline = PipelineUtils.getPipelineModelInfo(pipelineName, this.username());
        pipeline.addFeatureStep(featureType, config);
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }
}

