/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ModelConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionPipelineCreateProc;

@Generated(from="LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig", generator="Immutables")
public final class ImmutablePipelineDummyTrainConfig
implements LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig {
    private final String username;
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final Map<String, Object> toMap;
    private final String modelName;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePipelineDummyTrainConfig(String username, String modelName) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.username = this.initShim.username();
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.initShim = null;
    }

    private ImmutablePipelineDummyTrainConfig(Builder builder) {
        this.modelName = builder.modelName;
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        this.username = this.initShim.username();
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.initShim = null;
    }

    private ImmutablePipelineDummyTrainConfig(String username, @Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, String modelName) {
        this.initShim.username(username);
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.modelName = modelName;
        this.username = this.initShim.username();
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.initShim = null;
    }

    private String usernameInitialize() {
        return LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig.super.username();
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig.super.toMap();
    }

    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public String modelName() {
        return this.modelName;
    }

    public final ImmutablePipelineDummyTrainConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutablePipelineDummyTrainConfig(newValue, this.usernameOverride, this.sudo, this.configKeys, this.modelName);
    }

    public final ImmutablePipelineDummyTrainConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return new ImmutablePipelineDummyTrainConfig(this.username, value, this.sudo, this.configKeys, this.modelName);
    }

    public final ImmutablePipelineDummyTrainConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return new ImmutablePipelineDummyTrainConfig(this.username, this.usernameOverride, value, this.configKeys, this.modelName);
    }

    public final ImmutablePipelineDummyTrainConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return new ImmutablePipelineDummyTrainConfig(this.username, this.usernameOverride, this.sudo, newValue, this.modelName);
    }

    public final ImmutablePipelineDummyTrainConfig withModelName(String value) {
        String newValue = Objects.requireNonNull(value, "modelName");
        if (this.modelName.equals(newValue)) {
            return this;
        }
        return new ImmutablePipelineDummyTrainConfig(this.username, this.usernameOverride, this.sudo, this.configKeys, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePipelineDummyTrainConfig && this.equalTo((ImmutablePipelineDummyTrainConfig)another);
    }

    private boolean equalTo(ImmutablePipelineDummyTrainConfig another) {
        return this.username.equals(another.username) && Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.modelName.equals(another.modelName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.modelName.hashCode();
        return h;
    }

    public String toString() {
        return "PipelineDummyTrainConfig{username=" + this.username + ", usernameOverride=" + this.usernameOverride + ", sudo=" + this.sudo + ", modelName=" + this.modelName + "}";
    }

    public static LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig of(String username, String modelName) {
        return new ImmutablePipelineDummyTrainConfig(username, modelName);
    }

    public static LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig copyOf(LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig instance) {
        if (instance instanceof ImmutablePipelineDummyTrainConfig) {
            return (ImmutablePipelineDummyTrainConfig)instance;
        }
        return ImmutablePipelineDummyTrainConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MODEL_NAME = 1L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private long initBits = 1L;
        private long optBits;
        private String username;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private String modelName;

        private Builder() {
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ModelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseConfig instance;
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.sudo(instance.sudo());
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.username(instance.username());
            }
            if (object instanceof ModelConfig) {
                instance = (ModelConfig)object;
                this.modelName(instance.modelName());
            }
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder modelName(String modelName) {
            this.modelName = Objects.requireNonNull(modelName, "modelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.username = null;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.modelName = null;
            return this;
        }

        public LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePipelineDummyTrainConfig(this);
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("modelName");
            }
            return "Cannot build PipelineDummyTrainConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="LinkPredictionPipelineCreateProc.PipelineDummyTrainConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameBuildStage = 0;
        private String username;
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;

        private InitShim() {
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutablePipelineDummyTrainConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutablePipelineDummyTrainConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutablePipelineDummyTrainConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutablePipelineDummyTrainConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutablePipelineDummyTrainConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            return "Cannot build PipelineDummyTrainConfig, attribute initializers form cycle " + attributes;
        }
    }
}

