/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.cypher;

import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.common.Edition;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementException;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.gds.catalog.CatalogProc;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat.StorageEngineProxy;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.cypher.CypherGraphStore;
import org.neo4j.gds.core.cypher.CypherGraphStoreCatalogHelper;
import org.neo4j.gds.core.cypher.GraphStoreWrapper;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.loading.GraphStoreWithConfig;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphCreateCypherDbProc
extends CatalogProc {
    private static final String DESCRIPTION = "Creates a database from a GDS graph.";

    @Procedure(name="gds.alpha.create.cypherdb", mode=Mode.READ)
    @Description(value="Creates a database from a GDS graph.")
    public Stream<CreateCypherDbResult> createDb(@Name(value="dbName") String dbName, @Name(value="graphName") String graphName) {
        this.validateGraphName(graphName);
        CreateCypherDbResult result = (CreateCypherDbResult)this.runWithExceptionLogging("In-memory Cypher database creation failed", () -> {
            this.validateNeo4jEnterpriseEdition();
            MutableLong createMillis = new MutableLong(0L);
            try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((MutableLong)createMillis).setValue(arg_0));){
                DatabaseManagementService dbms = (DatabaseManagementService)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)this.api, DatabaseManagementService.class);
                GraphStoreWithConfig graphStoreWithConfig = GraphStoreCatalog.get((String)this.username(), (NamedDatabaseId)this.databaseId(), (String)graphName);
                CypherGraphStore cypherGraphStore = new CypherGraphStore(graphStoreWithConfig.graphStore());
                CypherGraphStoreCatalogHelper.setWrappedGraphStore((GraphCreateConfig)graphStoreWithConfig.config(), (GraphStoreWrapper)cypherGraphStore);
                StorageEngineProxy.createInMemoryDatabase((DatabaseManagementService)dbms, (String)dbName, (String)graphName, (Config)Config.defaults());
            }
            return new CreateCypherDbResult(dbName, graphName, createMillis.getValue());
        });
        return Stream.of(result);
    }

    private void validateNeo4jEnterpriseEdition() {
        Edition edition = StorageEngineProxy.dbmsEdition((GraphDatabaseAPI)this.api);
        if (edition != Edition.ENTERPRISE) {
            throw new DatabaseManagementException(StringFormatting.formatWithLocale((String)"Requires Neo4j %s version, but found %s", (Object[])new Object[]{Edition.ENTERPRISE, edition}));
        }
    }

    public static class CreateCypherDbResult {
        public final String dbName;
        public final String graphName;
        public final long createMillis;

        public CreateCypherDbResult(String dbName, String graphName, long createMillis) {
            this.dbName = dbName;
            this.graphName = graphName;
            this.createMillis = createMillis;
        }
    }
}

