/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.approxmaxkcut;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.approxmaxkcut.ApproxMaxKCutProc;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.impl.approxmaxkcut.ApproxMaxKCut;
import org.neo4j.gds.impl.approxmaxkcut.ApproxMaxKCutMutateConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ApproxMaxKCutMutateProc
extends MutatePropertyProc<ApproxMaxKCut, ApproxMaxKCut.CutResult, MutateResult, ApproxMaxKCutMutateConfig> {
    @Procedure(value="gds.alpha.maxkcut.mutate", mode=Mode.READ)
    @Description(value="Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.")
    public Stream<MutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(value="gds.alpha.maxkcut.mutate.estimate", mode=Mode.READ)
    @Description(value="Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected ApproxMaxKCutMutateConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ApproxMaxKCutMutateConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<ApproxMaxKCut, ApproxMaxKCutMutateConfig> algorithmFactory() {
        return ApproxMaxKCutProc.algorithmFactory();
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(AlgoBaseProc.ComputationResult<ApproxMaxKCut, ApproxMaxKCut.CutResult, ApproxMaxKCutMutateConfig> computeResult) {
        return new MutateResult.Builder(((ApproxMaxKCut.CutResult)computeResult.result()).cutCost());
    }

    protected NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<ApproxMaxKCut, ApproxMaxKCut.CutResult, ApproxMaxKCutMutateConfig> computationResult) {
        return ApproxMaxKCutProc.nodeProperties(computationResult);
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long nodePropertiesWritten;
        public final double cutCost;

        MutateResult(long nodePropertiesWritten, double cutCost, long createMillis, long computeMillis, long postProcessingMillis, long mutateMillis, Map<String, Object> config) {
            super(createMillis, computeMillis, postProcessingMillis, mutateMillis, config);
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.cutCost = cutCost;
        }

        static final class Builder
        extends AbstractResultBuilder<MutateResult> {
            private final double cutCost;

            Builder(double cutCost) {
                this.cutCost = cutCost;
            }

            public MutateResult build() {
                return new MutateResult(this.nodePropertiesWritten, this.cutCost, this.createMillis, this.computeMillis, 0L, this.mutateMillis, this.config.toMap());
            }
        }
    }
}

