/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.impl.similarity.CosineAlgorithm;
import org.neo4j.gds.impl.similarity.CosineConfig;
import org.neo4j.gds.impl.similarity.CosineConfigImpl;
import org.neo4j.gds.results.SimilarityResult;
import org.neo4j.gds.results.SimilarityStatsResult;
import org.neo4j.gds.results.SimilaritySummaryResult;
import org.neo4j.gds.similarity.AlphaSimilarityProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class CosineProc
extends AlphaSimilarityProc<CosineAlgorithm, CosineConfig> {
    private static final String DESCRIPTION = "Cosine-similarity is an algorithm for finding similar nodes based on the cosine similarity metric.";

    @Procedure(name="gds.alpha.similarity.cosine.stream", mode=Mode.READ)
    @Description(value="Cosine-similarity is an algorithm for finding similar nodes based on the cosine similarity metric.")
    public Stream<SimilarityResult> cosineStream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.cosine.write", mode=Mode.WRITE)
    @Description(value="Cosine-similarity is an algorithm for finding similar nodes based on the cosine similarity metric.")
    public Stream<SimilaritySummaryResult> cosineWrite(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.cosine.stats", mode=Mode.READ)
    @Description(value="Cosine-similarity is an algorithm for finding similar nodes based on the cosine similarity metric.")
    public Stream<SimilarityStatsResult> cosineStats(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats(graphNameOrConfig, configuration);
    }

    protected CosineConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper userInput) {
        return new CosineConfigImpl(graphName, maybeImplicitCreate, username, userInput);
    }

    @Override
    CosineAlgorithm newAlgo(CosineConfig config, AllocationTracker allocationTracker) {
        return new CosineAlgorithm(config, this.api);
    }

    @Override
    String taskName() {
        return "Cosine-similarity";
    }
}

