/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionSplitConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.NodePropertyStep;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureStep;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureStepFactory;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionTrainConfig;
import org.neo4j.gds.utils.StringFormatting;

public class TrainingPipeline
implements Model.Mappable {
    private final List<NodePropertyStep> nodePropertySteps = new ArrayList<NodePropertyStep>();
    private final List<LinkFeatureStep> featureSteps = new ArrayList<LinkFeatureStep>();
    private LinkPredictionSplitConfig splitConfig = LinkPredictionSplitConfig.of(CypherMapWrapper.empty());
    @NotNull
    private List<Map<String, Object>> parameterSpace = List.of(LinkLogisticRegressionTrainConfig.of((int)4, Map.of()).toMap());

    public TrainingPipeline copy() {
        TrainingPipeline copied = new TrainingPipeline();
        copied.featureSteps.addAll(this.featureSteps);
        copied.nodePropertySteps.addAll(this.nodePropertySteps);
        copied.setParameterSpace(new ArrayList<Map<String, Object>>(this.parameterSpace));
        copied.setSplitConfig(this.splitConfig);
        return copied;
    }

    public Map<String, Object> toMap() {
        return Map.of("featurePipeline", Map.of("nodePropertySteps", Model.Mappable.toMap(this.nodePropertySteps), "featureSteps", Model.Mappable.toMap(this.featureSteps)), "splitConfig", this.splitConfig.toMap(), "parameterSpace", this.parameterSpace);
    }

    public List<NodePropertyStep> nodePropertySteps() {
        return this.nodePropertySteps;
    }

    public void addNodePropertyStep(NodePropertyStep step) {
        this.nodePropertySteps.add(step);
    }

    public List<LinkFeatureStep> featureSteps() {
        return this.featureSteps;
    }

    void addFeatureStep(String name, Map<String, Object> config) {
        this.addFeatureStep(LinkFeatureStepFactory.create((String)name, config));
    }

    public void addFeatureStep(LinkFeatureStep step) {
        this.featureSteps.add(step);
    }

    LinkPredictionSplitConfig splitConfig() {
        return this.splitConfig;
    }

    void setSplitConfig(@NotNull LinkPredictionSplitConfig splitConfig) {
        this.splitConfig = splitConfig;
    }

    List<Map<String, Object>> parameterSpace() {
        return this.parameterSpace;
    }

    public void setParameterSpace(@NotNull List<Map<String, Object>> parameterList) {
        this.parameterSpace = parameterList.stream().map(trainParams -> {
            Map validatedConfig = LinkLogisticRegressionTrainConfig.of((int)4, (Map)trainParams).toMap();
            if (!trainParams.containsKey("concurrency")) {
                validatedConfig.remove("concurrency");
            }
            return validatedConfig;
        }).collect(Collectors.toList());
    }

    List<LinkLogisticRegressionTrainConfig> parameterConfigs(int concurrency) {
        return this.parameterSpace().stream().map(params -> LinkLogisticRegressionTrainConfig.of((int)concurrency, (Map)params)).collect(Collectors.toList());
    }

    public void validate(Graph graph) {
        Set graphProperties = graph.availableNodeProperties();
        List invalidProperties = this.featureSteps().stream().flatMap(step -> step.inputNodeProperties().stream()).filter(property -> !graphProperties.contains(property)).collect(Collectors.toList());
        if (!invalidProperties.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node properties %s defined in the LinkFeatureSteps do not exist in the graph or part of the pipeline", (Object[])new Object[]{invalidProperties}));
        }
    }

    public void validate() {
        if (this.featureSteps().isEmpty()) {
            throw new IllegalArgumentException("Training a Link prediction pipeline requires at least one feature. You can add features with the procedure `gds.alpha.ml.pipeline.linkPrediction.addFeature`.");
        }
    }
}

