/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.centrality;

import java.util.Map;
import java.util.Optional;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.NodePropertiesWriter;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMapping;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.DoubleNodeProperties;
import org.neo4j.gds.centrality.AsUndirected;
import org.neo4j.gds.centrality.HarmonicCentralityAlgorithmFactory;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.progress.tasks.LeafTask;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.impl.closeness.HarmonicCentralityConfig;
import org.neo4j.gds.impl.harmonic.HarmonicCentrality;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.gds.results.CentralityScore;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class HarmonicCentralityProc
extends NodePropertiesWriter<HarmonicCentrality, HarmonicCentrality, HarmonicCentralityConfig> {
    private static final String DESCRIPTION = "Harmonic centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.";

    @Procedure(name="gds.alpha.closeness.harmonic.stream", mode=Mode.READ)
    @Description(value="Harmonic centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<StreamResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        HarmonicCentrality algorithm = (HarmonicCentrality)computationResult.algorithm();
        Graph graph = computationResult.graph();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.empty();
        }
        return LongStream.range(0L, graph.nodeCount()).boxed().map(nodeId -> new StreamResult(graph.toOriginalNodeId(nodeId.longValue()), algorithm.getCentralityScore(nodeId.longValue())));
    }

    @Procedure(value="gds.alpha.closeness.harmonic.write", mode=Mode.WRITE)
    @Description(value="Harmonic centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<CentralityScore.Stats> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        final AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        HarmonicCentrality algorithm = (HarmonicCentrality)computationResult.algorithm();
        HarmonicCentralityConfig config = (HarmonicCentralityConfig)computationResult.config();
        Graph graph = computationResult.graph();
        CentralityScore.Stats.Builder builder = new CentralityScore.Stats.Builder(this.callContext, config.concurrency());
        builder.withNodeCount(graph.nodeCount()).withConfig((AlgoBaseConfig)config).withComputeMillis(computationResult.computeMillis()).withCreateMillis(computationResult.createMillis());
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of((CentralityScore.Stats)builder.build());
        }
        builder.withCentralityFunction(arg_0 -> ((HarmonicCentrality)((HarmonicCentrality)computationResult.result())).getCentralityScore(arg_0));
        try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((AbstractCentralityResultBuilder)builder).withWriteMillis(arg_0));){
            int writeConcurrency = ((HarmonicCentralityConfig)computationResult.config()).writeConcurrency();
            LeafTask task = Tasks.leaf((String)"HarmonicCentrality :: WriteNodeProperties", (long)graph.nodeCount());
            TaskProgressTracker progressTracker = new TaskProgressTracker((Task)task, this.log, writeConcurrency, this.taskRegistryFactory);
            NodePropertyExporter exporter = this.nodePropertyExporterBuilder.withIdMapping((IdMapping)graph).withTerminationFlag(algorithm.getTerminationFlag()).withProgressTracker((ProgressTracker)progressTracker).parallel(Pools.DEFAULT, writeConcurrency).build();
            DoubleNodeProperties properties = new DoubleNodeProperties(){

                public long size() {
                    return computationResult.graph().nodeCount();
                }

                public double doubleValue(long nodeId) {
                    return ((HarmonicCentrality)computationResult.result()).getCentralityScore(nodeId);
                }
            };
            progressTracker.beginSubTask();
            exporter.write(config.writeProperty(), (NodeProperties)properties);
            progressTracker.endSubTask();
        }
        return Stream.of((CentralityScore.Stats)builder.build());
    }

    protected HarmonicCentralityConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return HarmonicCentralityConfig.of(graphName, maybeImplicitCreate.map(AsUndirected::rewrite), (String)username, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<HarmonicCentrality, HarmonicCentralityConfig> algorithmFactory() {
        return new HarmonicCentralityAlgorithmFactory();
    }

    public static final class StreamResult {
        public final long nodeId;
        public final double centrality;

        StreamResult(long nodeId, double centrality) {
            this.nodeId = nodeId;
            this.centrality = centrality;
        }
    }
}

