/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.centrality;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.NodePropertiesWriter;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMapping;
import org.neo4j.gds.centrality.AsUndirected;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.progress.tasks.LeafTask;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.impl.closeness.ClosenessCentralityConfig;
import org.neo4j.gds.impl.closeness.MSClosenessCentrality;
import org.neo4j.gds.result.AbstractCentralityResultBuilder;
import org.neo4j.gds.results.CentralityScore;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ClosenessCentralityProc
extends NodePropertiesWriter<MSClosenessCentrality, MSClosenessCentrality, ClosenessCentralityConfig> {
    private static final String DESCRIPTION = "Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.";

    @Procedure(name="gds.alpha.closeness.stream", mode=Mode.READ)
    @Description(value="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<MSClosenessCentrality.Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        MSClosenessCentrality algorithm = (MSClosenessCentrality)computationResult.algorithm();
        Graph graph = computationResult.graph();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.empty();
        }
        graph.release();
        return algorithm.resultStream();
    }

    @Procedure(value="gds.alpha.closeness.write", mode=Mode.WRITE)
    @Description(value="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<CentralityScore.Stats> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        MSClosenessCentrality algorithm = (MSClosenessCentrality)computationResult.algorithm();
        ClosenessCentralityConfig config = (ClosenessCentralityConfig)computationResult.config();
        Graph graph = computationResult.graph();
        CentralityScore.Stats.Builder builder = new CentralityScore.Stats.Builder(this.callContext, config.concurrency());
        builder.withNodeCount(graph.nodeCount()).withConfig((AlgoBaseConfig)config).withComputeMillis(computationResult.computeMillis()).withCreateMillis(computationResult.createMillis());
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of((CentralityScore.Stats)builder.build());
        }
        builder.withCentralityFunction(arg_0 -> ((HugeDoubleArray)algorithm.getCentrality()).get(arg_0));
        try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((AbstractCentralityResultBuilder)builder).withWriteMillis(arg_0));){
            int writeConcurrency = ((ClosenessCentralityConfig)computationResult.config()).writeConcurrency();
            LeafTask task = Tasks.leaf((String)"ClosenessCentrality :: WriteNodeProperties", (long)graph.nodeCount());
            TaskProgressTracker progressTracker = new TaskProgressTracker((Task)task, this.log, writeConcurrency, this.taskRegistryFactory);
            NodePropertyExporter exporter = this.nodePropertyExporterBuilder.withIdMapping((IdMapping)graph).withTerminationFlag(algorithm.getTerminationFlag()).withProgressTracker((ProgressTracker)progressTracker).parallel(Pools.DEFAULT, writeConcurrency).build();
            algorithm.export(config.writeProperty(), exporter, (ProgressTracker)progressTracker);
        }
        graph.release();
        return Stream.of((CentralityScore.Stats)builder.build());
    }

    protected ClosenessCentralityConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ClosenessCentralityConfig.of(graphName, maybeImplicitCreate.map(AsUndirected::rewrite), (String)username, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<MSClosenessCentrality, ClosenessCentralityConfig> algorithmFactory() {
        return new AlgorithmFactory<MSClosenessCentrality, ClosenessCentralityConfig>(){

            protected String taskName() {
                return "ClosenessCentrality";
            }

            protected MSClosenessCentrality build(Graph graph, ClosenessCentralityConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                return new MSClosenessCentrality(graph, configuration.concurrency(), configuration.improved(), allocationTracker, Pools.DEFAULT, progressTracker);
            }
        };
    }
}

