/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.approxmaxkcut;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.approxmaxkcut.ApproxMaxKCutProc;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.impl.approxmaxkcut.ApproxMaxKCut;
import org.neo4j.gds.impl.approxmaxkcut.ApproxMaxKCutStreamConfig;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ApproxMaxKCutStreamProc
extends StreamProc<ApproxMaxKCut, ApproxMaxKCut.CutResult, StreamResult, ApproxMaxKCutStreamConfig> {
    @Procedure(value="gds.alpha.maxkcut.stream", mode=Mode.READ)
    @Description(value="Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.")
    public Stream<StreamResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(value="gds.alpha.maxkcut.stream.estimate", mode=Mode.READ)
    @Description(value="Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected ApproxMaxKCutStreamConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ApproxMaxKCutStreamConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<ApproxMaxKCut, ApproxMaxKCutStreamConfig> algorithmFactory() {
        return ApproxMaxKCutProc.algorithmFactory();
    }

    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        return new StreamResult(originalNodeId, nodeProperties.longValue(internalNodeId));
    }

    protected NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<ApproxMaxKCut, ApproxMaxKCut.CutResult, ApproxMaxKCutStreamConfig> computationResult) {
        return ApproxMaxKCutProc.nodeProperties(computationResult);
    }

    public static class StreamResult {
        public final long nodeId;
        public final long communityId;

        public StreamResult(long nodeId, long communityId) {
            this.nodeId = nodeId;
            this.communityId = communityId;
        }
    }
}

