/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.shortestpath;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMapping;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.DoubleNodeProperties;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.TransactionContext;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.impl.ShortestPathDeltaStepping;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.DeltaSteppingProcResult;
import org.neo4j.gds.shortestpath.ShortestPathDeltaSteppingConfig;
import org.neo4j.gds.utils.InputNodeValidator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ShortestPathDeltaSteppingProc
extends AlgoBaseProc<ShortestPathDeltaStepping, ShortestPathDeltaStepping, ShortestPathDeltaSteppingConfig> {
    private static final String DESCRIPTION = "Delta-Stepping is a non-negative single source shortest paths (NSSSP) algorithm.";

    @Procedure(name="gds.alpha.shortestPath.deltaStepping.stream", mode=Mode.READ)
    @Description(value="Delta-Stepping is a non-negative single source shortest paths (NSSSP) algorithm.")
    public Stream<ShortestPathDeltaStepping.DeltaSteppingResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        if (computationResult.graph().isEmpty()) {
            return Stream.empty();
        }
        return ((ShortestPathDeltaStepping)computationResult.result()).resultStream();
    }

    @Procedure(value="gds.alpha.shortestPath.deltaStepping.write", mode=Mode.WRITE)
    @Description(value="Delta-Stepping is a non-negative single source shortest paths (NSSSP) algorithm.")
    public Stream<DeltaSteppingProcResult> deltaStepping(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        final AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        Graph graph = computationResult.graph();
        ShortestPathDeltaStepping algorithm = (ShortestPathDeltaStepping)computationResult.algorithm();
        ShortestPathDeltaSteppingConfig config = (ShortestPathDeltaSteppingConfig)computationResult.config();
        AbstractResultBuilder builder = DeltaSteppingProcResult.builder().withNodeCount(graph.nodeCount());
        if (graph.isEmpty()) {
            return Stream.empty();
        }
        try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((AbstractResultBuilder)builder).withWriteMillis(arg_0));){
            final double[] shortestPaths = algorithm.getShortestPaths();
            DoubleNodeProperties properties = new DoubleNodeProperties(){

                public long size() {
                    return computationResult.graph().nodeCount();
                }

                public double doubleValue(long nodeId) {
                    return shortestPaths[(int)nodeId];
                }
            };
            ((NodePropertyExporter)NodePropertyExporter.builder((TransactionContext)TransactionContext.of((GraphDatabaseAPI)this.api, (Transaction)this.procedureTransaction), (IdMapping)graph, (TerminationFlag)algorithm.getTerminationFlag()).withLog(this.log).parallel(Pools.DEFAULT, config.writeConcurrency()).build()).write(config.writeProperty(), (NodeProperties)properties);
        }
        return Stream.of((DeltaSteppingProcResult)builder.build());
    }

    protected ShortestPathDeltaSteppingConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ShortestPathDeltaSteppingConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<ShortestPathDeltaStepping, ShortestPathDeltaSteppingConfig> algorithmFactory() {
        return (graph, configuration, tracker, log, eventTracker) -> {
            InputNodeValidator.validateStartNode(configuration.startNode(), graph);
            return new ShortestPathDeltaStepping(graph, configuration.startNode(), configuration.delta());
        };
    }
}

