/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.WriteProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.DoubleArrayNodeProperties;
import org.neo4j.gds.api.nodeproperties.LongNodeProperties;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredict;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictWriteConfig;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionResult;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPredictWriteProc
extends WriteProc<NodeClassificationPredict, NodeLogisticRegressionResult, Result, NodeClassificationPredictWriteConfig> {
    @Procedure(name="gds.alpha.ml.nodeClassification.predict.write", mode=Mode.WRITE)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<Result> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult result = this.compute(graphNameOrConfig, configuration);
        return this.write(result);
    }

    @Procedure(name="gds.alpha.ml.nodeClassification.predict.write.estimate", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected List<NodePropertyExporter.NodeProperty> nodePropertyList(final AlgoBaseProc.ComputationResult<NodeClassificationPredict, NodeLogisticRegressionResult, NodeClassificationPredictWriteConfig> computationResult) {
        NodeClassificationPredictWriteConfig config = (NodeClassificationPredictWriteConfig)computationResult.config();
        String writeProperty = config.writeProperty();
        NodeLogisticRegressionResult result = (NodeLogisticRegressionResult)computationResult.result();
        LongNodeProperties classProperties = result.predictedClasses().asNodeProperties();
        ArrayList<NodePropertyExporter.NodeProperty> nodeProperties = new ArrayList<NodePropertyExporter.NodeProperty>();
        nodeProperties.add(NodePropertyExporter.NodeProperty.of((String)writeProperty, (NodeProperties)classProperties));
        if (result.predictedProbabilities().isPresent()) {
            String probabilityPropertyKey = (String)config.predictedProbabilityProperty().orElseThrow();
            final HugeObjectArray probabilityProperties = (HugeObjectArray)result.predictedProbabilities().get();
            DoubleArrayNodeProperties properties = new DoubleArrayNodeProperties(){

                public long size() {
                    return computationResult.graph().nodeCount();
                }

                public double[] doubleArrayValue(long nodeId) {
                    return (double[])probabilityProperties.get(nodeId);
                }
            };
            nodeProperties.add(NodePropertyExporter.NodeProperty.of((String)probabilityPropertyKey, (NodeProperties)properties));
        }
        return nodeProperties;
    }

    protected NodeClassificationPredictWriteConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return NodeClassificationPredictWriteConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<NodeClassificationPredict, NodeClassificationPredictWriteConfig> algorithmFactory() {
        return new NodeClassificationPredictAlgorithmFactory();
    }

    protected AbstractResultBuilder<Result> resultBuilder(AlgoBaseProc.ComputationResult<NodeClassificationPredict, NodeLogisticRegressionResult, NodeClassificationPredictWriteConfig> computeResult) {
        return new Result.Builder();
    }

    public static class Result {
        public final long writeMillis;
        public final long nodePropertiesWritten;
        public final long createMillis;
        public final long computeMillis;
        public final Map<String, Object> configuration;

        public Result(long createMillis, long computeMillis, long writeMillis, long nodePropertiesWritten, Map<String, Object> configuration) {
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.configuration = configuration;
        }

        static class Builder
        extends AbstractResultBuilder<Result> {
            Builder() {
            }

            public Result build() {
                return new Result(this.createMillis, this.computeMillis, this.writeMillis, this.nodePropertiesWritten, this.config.toMap());
            }
        }
    }
}

