/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import com.carrotsearch.hppc.LongHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.LongStream;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.progress.v2.tasks.ProgressTracker;
import org.neo4j.gds.ml.core.batch.Batch;
import org.neo4j.gds.ml.core.batch.BatchQueue;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.pipeline.FeaturePipeline;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureExtractor;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionData;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionPredictor;

public class LinkPrediction
extends Algorithm<LinkPrediction, LinkPredictionResult> {
    private final LinkLogisticRegressionData modelData;
    private final FeaturePipeline featurePipeline;
    private final String graphName;
    private final List<NodeLabel> nodeLabels;
    private final List<RelationshipType> relationshipTypes;
    private final Graph graph;
    private final int concurrency;
    private final int topN;
    private final double threshold;

    public LinkPrediction(LinkLogisticRegressionData modelData, FeaturePipeline featurePipeline, String graphName, List<NodeLabel> nodeLabels, List<RelationshipType> relationshipTypes, Graph graph, int concurrency, int topN, double threshold, ProgressTracker progressTracker) {
        this.modelData = modelData;
        this.featurePipeline = featurePipeline;
        this.graphName = graphName;
        this.nodeLabels = nodeLabels;
        this.relationshipTypes = relationshipTypes;
        this.graph = graph;
        this.concurrency = concurrency;
        this.topN = topN;
        this.threshold = threshold;
        this.progressTracker = progressTracker;
    }

    public LinkPredictionResult compute() {
        this.computeNodeProperties();
        return this.predictLinks();
    }

    private void computeNodeProperties() {
        this.featurePipeline.executeNodePropertySteps(this.graphName, this.nodeLabels, this.relationshipTypes);
    }

    private LinkPredictionResult predictLinks() {
        LinkLogisticRegressionPredictor predictor = new LinkLogisticRegressionPredictor(this.modelData);
        LinkPredictionResult result = new LinkPredictionResult(this.topN);
        BatchQueue batchQueue = new BatchQueue(this.graph.nodeCount(), 100, this.concurrency);
        batchQueue.parallelConsume(this.concurrency, ignore -> new LinkPredictionScoreByIdsConsumer(this.graph.concurrentCopy(), this.featurePipeline.linkFeatureExtractor(this.graph), predictor, result, this.progressTracker));
        return result;
    }

    public LinkPrediction me() {
        return this;
    }

    public void release() {
    }

    private final class LinkPredictionScoreByIdsConsumer
    implements Consumer<Batch> {
        private final Graph graph;
        private final LinkFeatureExtractor linkFeatureExtractor;
        private final LinkLogisticRegressionPredictor predictor;
        private final LinkPredictionResult predictedLinks;
        private final ProgressTracker progressTracker;

        private LinkPredictionScoreByIdsConsumer(Graph graph, LinkFeatureExtractor linkFeatureExtractor, LinkLogisticRegressionPredictor predictor, LinkPredictionResult predictedLinks, ProgressTracker progressTracker) {
            this.graph = graph;
            this.linkFeatureExtractor = linkFeatureExtractor;
            this.predictor = predictor;
            this.predictedLinks = predictedLinks;
            this.progressTracker = progressTracker;
        }

        @Override
        public void accept(Batch batch) {
            Iterator iterator = batch.nodeIds().iterator();
            while (iterator.hasNext()) {
                long sourceId = (Long)iterator.next();
                LongHashSet largerNeighbors = this.largerNeighbors(sourceId);
                long smallestTarget = sourceId + 1L;
                LongStream.range(smallestTarget, this.graph.nodeCount()).forEach(targetId -> {
                    if (largerNeighbors.contains(targetId)) {
                        return;
                    }
                    double[] features = this.linkFeatureExtractor.extractFeatures(sourceId, targetId);
                    double probability = this.predictor.predictedProbability(features);
                    if (probability < LinkPrediction.this.threshold) {
                        return;
                    }
                    this.predictedLinks.add(sourceId, targetId, probability);
                });
            }
        }

        private LongHashSet largerNeighbors(long sourceId) {
            LongHashSet neighbors = new LongHashSet();
            this.graph.forEachRelationship(sourceId, (src, trg) -> {
                if (src < trg) {
                    neighbors.add(trg);
                }
                return true;
            });
            return neighbors;
        }
    }
}

