/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.ml.linkmodels.pipeline.NodePropertyStep;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureStep;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureStepFactory;

public class PipelineModelInfo
implements Model.Mappable {
    private final List<NodePropertyStep> nodePropertySteps = new ArrayList<NodePropertyStep>();
    private final List<LinkFeatureStep> featureSteps = new ArrayList<LinkFeatureStep>();
    private Map<String, Object> splitConfig;
    private List<Map<String, Object>> parameterSpace;

    public static PipelineModelInfo create() {
        return new PipelineModelInfo(Map.of(), List.of());
    }

    private PipelineModelInfo(@Nullable Map<String, Object> splitConfig, @Nullable List<Map<String, Object>> parameterSpace) {
        this.splitConfig = splitConfig;
        this.parameterSpace = parameterSpace;
    }

    public Map<String, Object> toMap() {
        return Map.of("featurePipeline", Map.of("nodePropertySteps", Model.Mappable.toMap(this.nodePropertySteps), "featureSteps", Model.Mappable.toMap(this.featureSteps)), "splitConfig", this.splitConfig, "parameterSpace", this.parameterSpace);
    }

    List<NodePropertyStep> nodePropertySteps() {
        return this.nodePropertySteps;
    }

    void addNodePropertyStep(String name, Map<String, Object> config) {
        this.nodePropertySteps.add(new NodePropertyStep(name, config));
    }

    List<LinkFeatureStep> featureSteps() {
        return this.featureSteps;
    }

    void addFeatureStep(String name, Map<String, Object> config) {
        this.featureSteps.add(LinkFeatureStepFactory.create((String)name, config));
    }

    Map<String, Object> splitConfig() {
        return this.splitConfig;
    }

    void setSplitConfig(@NotNull Map<String, Object> splitConfig) {
        this.splitConfig = splitConfig;
    }

    List<Map<String, Object>> parameterSpace() {
        return this.parameterSpace;
    }

    void setParameterSpace(@NotNull List<Map<String, Object>> parameterList) {
        this.parameterSpace = parameterList;
    }
}

