/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.ml.linkmodels.pipeline.procedureutils.ProcedureReflection;

public class NodePropertyStep
implements Model.Mappable {
    public final String taskName;
    public final Map<String, Object> config;

    NodePropertyStep(String taskName, Map<String, Object> config) {
        this.taskName = taskName;
        this.config = config;
    }

    public void execute(BaseProc caller, String graphName, Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relTypes) {
        HashMap<String, Object> configCopy = new HashMap<String, Object>(this.config);
        List nodeLabelStrings = nodeLabels.stream().map(ElementIdentifier::name).collect(Collectors.toList());
        List relTypeStrings = relTypes.stream().map(ElementIdentifier::name).collect(Collectors.toList());
        configCopy.put("nodeLabels", nodeLabelStrings);
        configCopy.put("relationshipTypes", relTypeStrings);
        this.execute(caller, graphName, configCopy);
    }

    public void execute(BaseProc caller, String graphName) {
        this.execute(caller, graphName, this.config);
    }

    private void execute(BaseProc caller, String graphName, Map<String, Object> config) {
        ProcedureReflection.INSTANCE.invokeProc(caller, graphName, this.taskName, config);
    }

    public Map<String, Object> toMap() {
        return Map.of("name", this.taskName, "config", this.config);
    }
}

