/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionTrainConfig;

public final class LinkPredictionTrainConfigImpl
implements LinkPredictionTrainConfig {
    private int validationFolds;
    private double negativeClassWeight;
    private List<Map<String, Object>> params;
    private double holdOutFraction;
    private double negativeSamplingRatio;
    private Optional<String> graphName;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    private Optional<GraphCreateConfig> implicitCreateConfig;
    private String username;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    private String modelName;
    private Optional<Long> randomSeed;

    public LinkPredictionTrainConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.validationFolds = config.requireInt("validationFolds");
            CypherMapWrapper.validateIntegerRange((String)"validationFolds", (int)this.validationFolds, (int)2, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.negativeClassWeight = config.requireDouble("negativeClassWeight");
            CypherMapWrapper.validateDoubleRange((String)"negativeClassWeight", (double)this.negativeClassWeight, (double)0.0, (double)Double.MAX_VALUE, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.params = (List)CypherMapWrapper.failOnNull((String)"params", (Object)((List)config.requireChecked("params", List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.holdOutFraction = config.requireDouble("holdOutFraction");
            CypherMapWrapper.validateDoubleRange((String)"holdOutFraction", (double)this.holdOutFraction, (double)0.0, (double)Double.MAX_VALUE, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.negativeSamplingRatio = config.requireDouble("negativeSamplingRatio");
            CypherMapWrapper.validateDoubleRange((String)"negativeSamplingRatio", (double)this.negativeSamplingRatio, (double)0.0, (double)Double.MAX_VALUE, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)LinkPredictionTrainConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)LinkPredictionTrainConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", LinkPredictionTrainConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", LinkPredictionTrainConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", LinkPredictionTrainConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.modelName = (String)CypherMapWrapper.failOnNull((String)"modelName", (Object)config.requireString("modelName"));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapWrapper.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int validationFolds() {
        return this.validationFolds;
    }

    @Override
    public double negativeClassWeight() {
        return this.negativeClassWeight;
    }

    @Override
    public List<Map<String, Object>> params() {
        return this.params;
    }

    @Override
    public double holdOutFraction() {
        return this.holdOutFraction;
    }

    @Override
    public double negativeSamplingRatio() {
        return this.negativeSamplingRatio;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("validationFolds", "negativeClassWeight", "params", "holdOutFraction", "negativeSamplingRatio", "relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "modelName", "randomSeed");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("validationFolds", this.validationFolds());
        map.put("negativeClassWeight", this.negativeClassWeight());
        map.put("params", this.params());
        map.put("holdOutFraction", this.holdOutFraction());
        map.put("negativeSamplingRatio", this.negativeSamplingRatio());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("modelName", this.modelName());
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public String modelName() {
        return this.modelName;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }
}

