/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.ModelConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.linkmodels.metrics.LinkMetric;
import org.neo4j.gds.ml.linkmodels.pipeline.ImmutableLinkPredictionTrainConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionTrainConfigImpl;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionTrainConfig;

@ValueClass
@Configuration
public interface LinkPredictionTrainConfig
extends AlgoBaseConfig,
ModelConfig,
RandomSeedConfig {
    @Configuration.IntegerRange(min=2)
    public int validationFolds();

    @Configuration.DoubleRange(min=0.0, minInclusive=false)
    public double negativeClassWeight();

    public List<Map<String, Object>> params();

    @Value.Derived
    @Configuration.Ignore
    default public List<LinkLogisticRegressionTrainConfig> paramConfigs() {
        return this.params().stream().map(params -> LinkLogisticRegressionTrainConfig.of((int)this.concurrency(), (Map)params)).collect(Collectors.toList());
    }

    @Configuration.DoubleRange(min=0.0, minInclusive=false)
    public double holdOutFraction();

    @Configuration.DoubleRange(min=0.0, minInclusive=false)
    public double negativeSamplingRatio();

    @Configuration.Ignore
    @Value.Default
    default public List<LinkMetric> metrics() {
        return List.of(LinkMetric.AUCPR);
    }

    public static LinkPredictionTrainConfig of(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return new LinkPredictionTrainConfigImpl(graphName, maybeImplicitCreate, username, config);
    }

    public static ImmutableLinkPredictionTrainConfig.Builder builder() {
        return ImmutableLinkPredictionTrainConfig.builder();
    }
}

