/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineInfoResult;
import org.neo4j.gds.ml.linkmodels.pipeline.PipelineModelInfo;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkFeaturePipelineAddStepProcs
extends BaseProc {
    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.addNodeProperty", mode=Mode.READ)
    @Description(value="Add a node property step to an existing link prediction pipeline.")
    public Stream<PipelineInfoResult> addNodeProperty(@Name(value="pipelineName") String pipelineName, @Name(value="procedureName") String taskName, @Name(value="procedureConfiguration") Map<String, Object> procedureConfig) {
        PipelineModelInfo pipeline = this.getPipelineModelInfo(pipelineName);
        pipeline.addNodePropertyStep(taskName, procedureConfig);
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }

    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.addFeature", mode=Mode.READ)
    @Description(value="Add a feature step to an existing link prediction pipeline.")
    public Stream<PipelineInfoResult> addFeature(@Name(value="pipelineName") String pipelineName, @Name(value="featureName") String featureName, @Name(value="config") Map<String, Object> config) {
        PipelineModelInfo pipeline = this.getPipelineModelInfo(pipelineName);
        pipeline.addFeatureStep(featureName, config);
        return Stream.of(new PipelineInfoResult(pipelineName, pipeline));
    }

    private PipelineModelInfo getPipelineModelInfo(String pipelineName) {
        Model model = ModelCatalog.getUntyped((String)this.username(), (String)pipelineName, (boolean)true);
        assert (model != null);
        if (!model.algoType().equals("Link prediction training pipeline")) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Steps can only be added to a model of type `%s`. But model `%s` is of type `%s`.", (Object[])new Object[]{"Link prediction training pipeline", pipelineName, model.algoType()}));
        }
        return (PipelineModelInfo)model.customInfo();
    }
}

