/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.linkmodels.metrics.LinkMetric;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionModelInfo;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionTrainConfig;
import org.neo4j.gds.ml.nodemodels.MetricData;

@Generated(from="LinkPredictionModelInfo", generator="Immutables")
public final class ImmutableLinkPredictionModelInfo
implements LinkPredictionModelInfo {
    private final LinkLogisticRegressionTrainConfig bestParameters;
    private final Map<LinkMetric, MetricData<LinkLogisticRegressionTrainConfig>> metrics;

    private ImmutableLinkPredictionModelInfo(LinkLogisticRegressionTrainConfig bestParameters, Map<LinkMetric, ? extends MetricData<LinkLogisticRegressionTrainConfig>> metrics) {
        this.bestParameters = Objects.requireNonNull(bestParameters, "bestParameters");
        this.metrics = ImmutableLinkPredictionModelInfo.createUnmodifiableEnumMap(true, false, metrics);
    }

    private ImmutableLinkPredictionModelInfo(ImmutableLinkPredictionModelInfo original, LinkLogisticRegressionTrainConfig bestParameters, Map<LinkMetric, MetricData<LinkLogisticRegressionTrainConfig>> metrics) {
        this.bestParameters = bestParameters;
        this.metrics = metrics;
    }

    @Override
    public LinkLogisticRegressionTrainConfig bestParameters() {
        return this.bestParameters;
    }

    @Override
    public Map<LinkMetric, MetricData<LinkLogisticRegressionTrainConfig>> metrics() {
        return this.metrics;
    }

    public final ImmutableLinkPredictionModelInfo withBestParameters(LinkLogisticRegressionTrainConfig value) {
        if (this.bestParameters == value) {
            return this;
        }
        LinkLogisticRegressionTrainConfig newValue = Objects.requireNonNull(value, "bestParameters");
        return new ImmutableLinkPredictionModelInfo(this, newValue, this.metrics);
    }

    public final ImmutableLinkPredictionModelInfo withMetrics(Map<LinkMetric, ? extends MetricData<LinkLogisticRegressionTrainConfig>> entries) {
        if (this.metrics == entries) {
            return this;
        }
        Map<LinkMetric, ? extends MetricData<LinkLogisticRegressionTrainConfig>> newValue = ImmutableLinkPredictionModelInfo.createUnmodifiableEnumMap(true, false, entries);
        return new ImmutableLinkPredictionModelInfo(this, this.bestParameters, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkPredictionModelInfo && this.equalTo((ImmutableLinkPredictionModelInfo)another);
    }

    private boolean equalTo(ImmutableLinkPredictionModelInfo another) {
        return this.bestParameters.equals(another.bestParameters) && this.metrics.equals(another.metrics);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.bestParameters.hashCode();
        h += (h << 5) + this.metrics.hashCode();
        return h;
    }

    public String toString() {
        return "LinkPredictionModelInfo{bestParameters=" + this.bestParameters + ", metrics=" + this.metrics + "}";
    }

    public static LinkPredictionModelInfo of(LinkLogisticRegressionTrainConfig bestParameters, Map<LinkMetric, ? extends MetricData<LinkLogisticRegressionTrainConfig>> metrics) {
        return new ImmutableLinkPredictionModelInfo(bestParameters, metrics);
    }

    public static LinkPredictionModelInfo copyOf(LinkPredictionModelInfo instance) {
        if (instance instanceof ImmutableLinkPredictionModelInfo) {
            return (ImmutableLinkPredictionModelInfo)instance;
        }
        return ImmutableLinkPredictionModelInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K extends Enum<K>, V> Map<K, V> createUnmodifiableEnumMap(boolean checkNulls, boolean skipNulls, Map<K, ? extends V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        EnumMap<K, ? extends V> enumMap = new EnumMap<K, V>(map);
        if (checkNulls || skipNulls) {
            Iterator<V> it = map.values().iterator();
            while (it.hasNext()) {
                V v = it.next();
                if (checkNulls) {
                    Objects.requireNonNull(v, "value");
                    continue;
                }
                if (!skipNulls || v != null) continue;
                it.remove();
            }
        }
        return Collections.unmodifiableMap(enumMap);
    }

    @Generated(from="LinkPredictionModelInfo", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_BEST_PARAMETERS = 1L;
        private long initBits = 1L;
        private LinkLogisticRegressionTrainConfig bestParameters;
        private EnumMap<LinkMetric, MetricData<LinkLogisticRegressionTrainConfig>> metrics = null;

        private Builder() {
        }

        public final Builder from(LinkPredictionModelInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.bestParameters(instance.bestParameters());
            this.putAllMetrics(instance.metrics());
            return this;
        }

        public final Builder bestParameters(LinkLogisticRegressionTrainConfig bestParameters) {
            this.bestParameters = Objects.requireNonNull(bestParameters, "bestParameters");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putMetric(LinkMetric key, MetricData<LinkLogisticRegressionTrainConfig> value) {
            if (this.metrics == null) {
                this.metrics = new EnumMap(LinkMetric.class);
            }
            this.metrics.put(Objects.requireNonNull(key, "metrics key"), Objects.requireNonNull(value, "metrics value"));
            return this;
        }

        public final Builder putMetric(Map.Entry<LinkMetric, ? extends MetricData<LinkLogisticRegressionTrainConfig>> entry) {
            if (this.metrics == null) {
                this.metrics = new EnumMap(LinkMetric.class);
            }
            LinkMetric k = entry.getKey();
            MetricData<LinkLogisticRegressionTrainConfig> v = entry.getValue();
            this.metrics.put(Objects.requireNonNull(k, "metrics key"), Objects.requireNonNull(v, "metrics value"));
            return this;
        }

        public final Builder metrics(Map<LinkMetric, ? extends MetricData<LinkLogisticRegressionTrainConfig>> entries) {
            this.metrics = new EnumMap(LinkMetric.class);
            return this.putAllMetrics(entries);
        }

        public final Builder putAllMetrics(Map<LinkMetric, ? extends MetricData<LinkLogisticRegressionTrainConfig>> entries) {
            if (this.metrics == null) {
                this.metrics = new EnumMap(LinkMetric.class);
            }
            for (Map.Entry<LinkMetric, ? extends MetricData<LinkLogisticRegressionTrainConfig>> e : entries.entrySet()) {
                LinkMetric k = e.getKey();
                MetricData<LinkLogisticRegressionTrainConfig> v = e.getValue();
                this.metrics.put(Objects.requireNonNull(k, "metrics key"), Objects.requireNonNull(v, "metrics value"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.bestParameters = null;
            if (this.metrics != null) {
                this.metrics.clear();
            }
            return this;
        }

        public LinkPredictionModelInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLinkPredictionModelInfo(null, this.bestParameters, this.metrics == null ? Collections.emptyMap() : ImmutableLinkPredictionModelInfo.createUnmodifiableEnumMap(false, false, this.metrics));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bestParameters");
            }
            return "Cannot build LinkPredictionModelInfo, some of required attributes are not set " + attributes;
        }
    }
}

