/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.ml.linkmodels.pipeline.NodePropertyStep;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureExtractor;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureStep;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.kernel.database.NamedDatabaseId;

public class FeaturePipeline {
    private final List<NodePropertyStep> nodePropertySteps;
    private final List<LinkFeatureStep> linkFeatureSteps;
    private final String userName;
    private final NamedDatabaseId databaseId;
    private final BaseProc caller;

    public FeaturePipeline(List<NodePropertyStep> nodePropertySteps, List<LinkFeatureStep> linkFeatureSteps, BaseProc caller, NamedDatabaseId databaseId, String userName) {
        this.nodePropertySteps = nodePropertySteps;
        this.linkFeatureSteps = linkFeatureSteps;
        this.caller = caller;
        this.userName = userName;
        this.databaseId = databaseId;
    }

    public HugeObjectArray<double[]> computeFeatures(String graphName, Collection<NodeLabel> nodeLabels, RelationshipType relationshipType, int concurrency) {
        Graph graph = GraphStoreCatalog.get((String)this.userName, (NamedDatabaseId)this.databaseId, (String)graphName).graphStore().getGraph(nodeLabels, List.of(relationshipType), Optional.empty());
        this.validate(graph);
        return LinkFeatureExtractor.extractFeatures((Graph)graph, this.linkFeatureSteps, (int)concurrency);
    }

    public LinkFeatureExtractor linkFeatureExtractor(Graph graph) {
        return LinkFeatureExtractor.of((Graph)graph, this.linkFeatureSteps);
    }

    public void executeNodePropertySteps(String graphName, Collection<NodeLabel> nodeLabels, RelationshipType relationshipType) {
        this.executeNodePropertySteps(graphName, nodeLabels, List.of(relationshipType));
    }

    public void executeNodePropertySteps(String graphName, Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes) {
        for (NodePropertyStep step : this.nodePropertySteps) {
            step.execute(this.caller, graphName, nodeLabels, relationshipTypes);
        }
    }

    private void validate(Graph graph) {
        Set graphProperties = graph.availableNodeProperties();
        List invalidProperties = this.linkFeatureSteps.stream().flatMap(step -> step.inputNodeProperties().stream()).filter(property -> !graphProperties.contains(property)).collect(Collectors.toList());
        if (!invalidProperties.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node properties %s defined in the LinkFeatureSteps do not exist in the graph or part of the pipeline", (Object[])new Object[]{invalidProperties}));
        }
    }
}

