/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.WriteRelationshipsProc;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.GraphCreateConfigValidations;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredict;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredictFactory;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredictWriteConfig;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardWriteRelationshipsResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionPredictWriteProc
extends WriteRelationshipsProc<LinkPredictionPredict, LinkPredictionResult, StandardWriteRelationshipsResult, LinkPredictionPredictWriteConfig> {
    @Procedure(name="gds.alpha.ml.linkPrediction.predict.write", mode=Mode.WRITE)
    @Description(value="Predicts relationships for all node pairs based on a previously trained link prediction model.")
    public Stream<StandardWriteRelationshipsResult> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(name="gds.alpha.ml.linkPrediction.predict.write.estimate", mode=Mode.READ)
    @Description(value="Estimates memory for applying a linkPrediction model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected void validateConfigsBeforeLoad(GraphCreateConfig graphCreateConfig, LinkPredictionPredictWriteConfig config) {
        GraphCreateConfigValidations.validateIsUndirectedGraph((GraphCreateConfig)graphCreateConfig, (AlgoBaseConfig)config);
    }

    protected LinkPredictionPredictWriteConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return LinkPredictionPredictWriteConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<LinkPredictionPredict, LinkPredictionPredictWriteConfig> algorithmFactory() {
        return new LinkPredictionPredictFactory();
    }

    protected AbstractResultBuilder<StandardWriteRelationshipsResult> resultBuilder(AlgoBaseProc.ComputationResult<LinkPredictionPredict, LinkPredictionResult, LinkPredictionPredictWriteConfig> computeResult) {
        return new StandardWriteRelationshipsResult.Builder();
    }
}

