/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.core.utils.BatchingProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.progress.ProgressEventTracker;
import org.neo4j.graphalgo.core.utils.progress.v2.tasks.ProgressTracker;
import org.neo4j.graphalgo.core.utils.progress.v2.tasks.TaskProgressTracker;
import org.neo4j.graphalgo.exceptions.MemoryEstimationNotImplementedException;
import org.neo4j.logging.Log;

@FunctionalInterface
public interface AlphaAlgorithmFactory<ALGO extends Algorithm<ALGO, ?>, CONFIG extends AlgoBaseConfig>
extends AlgorithmFactory<ALGO, CONFIG> {
    default public ALGO build(Graph graph, CONFIG configuration, AllocationTracker tracker, Log log, ProgressEventTracker eventTracker) {
        ALGO algo = this.buildAlphaAlgo(graph, configuration, tracker, log, eventTracker);
        return (ALGO)algo.withProgressTracker((ProgressTracker)new TaskProgressTracker(this.progressTask(graph, (AlgoBaseConfig)configuration), (ProgressLogger)new BatchingProgressLogger(log, 0L, algo.getClass().getSimpleName(), configuration.concurrency())));
    }

    public ALGO buildAlphaAlgo(Graph var1, CONFIG var2, AllocationTracker var3, Log var4, ProgressEventTracker var5);

    default public MemoryEstimation memoryEstimation(CONFIG configuration) {
        throw new MemoryEstimationNotImplementedException();
    }
}

