/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.pregel.SpeakerListenerLPA;
import org.neo4j.gds.pregel.SpeakerListenerLPAAlgorithm;
import org.neo4j.graphalgo.AbstractAlgorithmFactory;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.beta.pregel.Pregel;
import org.neo4j.graphalgo.beta.pregel.PregelMutateProc;
import org.neo4j.graphalgo.beta.pregel.PregelMutateResult;
import org.neo4j.graphalgo.beta.pregel.PregelResult;
import org.neo4j.graphalgo.beta.pregel.PregelSchema;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.progress.v2.tasks.ProgressTracker;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class SpeakerListenerLPAMutateProc
extends PregelMutateProc<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig> {
    @Procedure(name="gds.alpha.sllpa.mutate", mode=Mode.READ)
    @Description(value="The Speaker Listener Label Propagation algorithm is a fast algorithm for finding overlapping communities in a graph.")
    public Stream<PregelMutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(name="gds.alpha.sllpa.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> mutateEstimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected AbstractResultBuilder<PregelMutateResult> resultBuilder(AlgoBaseProc.ComputationResult<SpeakerListenerLPAAlgorithm, PregelResult, SpeakerListenerLPA.SpeakerListenerLPAConfig> computeResult) {
        int ranIterations = ((PregelResult)computeResult.result()).ranIterations();
        boolean didConverge = ((PregelResult)computeResult.result()).didConverge();
        return new PregelMutateResult.Builder().withRanIterations((long)ranIterations).didConverge(didConverge);
    }

    protected SpeakerListenerLPA.SpeakerListenerLPAConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig> algorithmFactory() {
        return new AbstractAlgorithmFactory<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig>(){

            public SpeakerListenerLPAAlgorithm build(Graph graph, SpeakerListenerLPA.SpeakerListenerLPAConfig configuration, AllocationTracker tracker, ProgressTracker progressTracker) {
                return new SpeakerListenerLPAAlgorithm(graph, configuration, tracker, progressTracker.progressLogger());
            }

            protected long taskVolume(Graph graph, SpeakerListenerLPA.SpeakerListenerLPAConfig config) {
                return graph.nodeCount();
            }

            protected String taskName() {
                return SpeakerListenerLPAAlgorithm.class.getSimpleName();
            }

            public MemoryEstimation memoryEstimation(SpeakerListenerLPA.SpeakerListenerLPAConfig configuration) {
                SpeakerListenerLPA computation = new SpeakerListenerLPA();
                return Pregel.memoryEstimation((PregelSchema)computation.schema(configuration), (boolean)computation.reducer().isPresent(), (boolean)configuration.isAsynchronous());
            }
        };
    }
}

