/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.procedureutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.BaseProc;
import org.neo4j.graphalgo.utils.StringFormatting;
import org.neo4j.procedure.Procedure;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;

public final class ProcedureReflection {
    private static final List<String> PACKAGES_TO_SCAN = List.of("org.neo4j.graphalgo", "org.neo4j.gds");
    private final List<Method> procedureMethods = PACKAGES_TO_SCAN.stream().map(this::createReflections).map(r -> r.getMethodsAnnotatedWith(Procedure.class)).flatMap(Collection::stream).collect(Collectors.toList());
    public static final ProcedureReflection INSTANCE = new ProcedureReflection();

    private ProcedureReflection() {
    }

    public Method findProcedureMethod(String procName) {
        List<Method> foundMethods = this.filterAlgoBaseMethods(procName);
        if (foundMethods.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Invalid procedure name `%s` for pipelining.", (Object[])new Object[]{procName}));
        }
        if (foundMethods.size() > 1) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Ambiguous procedure name `%s`. Found matching procedures %s.", (Object[])new Object[]{procName, foundMethods.stream().map(this::procedureName).collect(Collectors.joining(", "))}));
        }
        return foundMethods.get(0);
    }

    private List<Method> filterAlgoBaseMethods(String shortName) {
        return this.procedureMethods.stream().filter(method -> {
            if (!AlgoBaseProc.class.isAssignableFrom(method.getDeclaringClass())) {
                return false;
            }
            return ProcedureReflection.validShortName(this.procedureName((Method)method), shortName);
        }).collect(Collectors.toList());
    }

    private static boolean validShortName(String fullName, String shortName) {
        String normalizedFullName = "." + fullName;
        String normalizedShortName = "." + shortName + (shortName.endsWith(".mutate") ? "" : ".mutate");
        return normalizedFullName.endsWith(normalizedShortName);
    }

    private String procedureName(Method method) {
        Procedure annotation = method.getAnnotation(Procedure.class);
        return annotation.name().isEmpty() ? annotation.value() : annotation.name();
    }

    private AlgoBaseProc<?, ?, ?> createProcedure(BaseProc caller, Method method) {
        AlgoBaseProc proc;
        try {
            proc = (AlgoBaseProc)method.getDeclaringClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            proc.api = caller.api;
            proc.callContext = caller.callContext;
            proc.log = caller.log;
            proc.procedureTransaction = caller.procedureTransaction;
            proc.tracker = caller.tracker;
            proc.transaction = caller.transaction;
            proc.progressTracker = caller.progressTracker;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return proc;
    }

    public void invokeProc(BaseProc caller, String graphName, String procName, Map<String, Object> config) {
        Method method = this.findProcedureMethod(procName);
        AlgoBaseProc<?, ?, ?> procedure = this.createProcedure(caller, method);
        try {
            method.invoke(procedure, graphName, config);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Reflections createReflections(String pkg) {
        return new Reflections(pkg, new Scanner[]{new MethodAnnotationsScanner()});
    }
}

