/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.gds.ml.linkmodels.pipeline.procedureutils.ProcedureReflection;
import org.neo4j.graphalgo.BaseProc;
import org.neo4j.graphalgo.ElementIdentifier;
import org.neo4j.graphalgo.NodeLabel;
import org.neo4j.graphalgo.RelationshipType;

public class ProcedureStep {
    public final String taskName;
    public final Map<String, Object> config;

    ProcedureStep(String taskName, Map<String, Object> config) {
        this.taskName = taskName;
        this.config = config;
    }

    public void execute(BaseProc caller, String graphName, Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relTypes) {
        HashMap<String, Object> configCopy = new HashMap<String, Object>(this.config);
        List nodeLabelStrings = nodeLabels.stream().map(ElementIdentifier::name).collect(Collectors.toList());
        List relTypeStrings = relTypes.stream().map(ElementIdentifier::name).collect(Collectors.toList());
        configCopy.put("nodeLabels", nodeLabelStrings);
        configCopy.put("relationshipTypes", relTypeStrings);
        this.execute(caller, graphName, configCopy);
    }

    public void execute(BaseProc caller, String graphName) {
        this.execute(caller, graphName, this.config);
    }

    private void execute(BaseProc caller, String graphName, Map<String, Object> config) {
        ProcedureReflection.INSTANCE.invokeProc(caller, graphName, this.taskName, config);
    }
}

