/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.ml.linkmodels.pipeline.ProcedureStep;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureStep;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureStepFactory;
import org.neo4j.graphalgo.BaseProc;
import org.neo4j.graphalgo.NodeLabel;
import org.neo4j.graphalgo.RelationshipType;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.loading.GraphStoreCatalog;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeObjectArray;
import org.neo4j.graphalgo.utils.StringFormatting;
import org.neo4j.kernel.database.NamedDatabaseId;

public class FeaturePipeline {
    private List<ProcedureStep> procedureSteps;
    private List<LinkFeatureStep> linkFeatureSteps;
    private final String userName;
    private final NamedDatabaseId databaseId;
    private final BaseProc caller;

    public FeaturePipeline(BaseProc caller, NamedDatabaseId databaseId, String userName) {
        this.caller = caller;
        this.userName = userName;
        this.databaseId = databaseId;
        this.linkFeatureSteps = new ArrayList<LinkFeatureStep>();
        this.procedureSteps = new ArrayList<ProcedureStep>();
    }

    public void addLinkFeature(String name, Map<String, Object> config) {
        this.linkFeatureSteps.add(LinkFeatureStepFactory.create((String)name, config));
    }

    public void addProcedureStep(String name, Map<String, Object> config) {
        this.procedureSteps.add(new ProcedureStep(name, config));
    }

    public HugeObjectArray<double[]> computeFeatures(String graphName, Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes) {
        this.executeProcedureSteps(graphName, nodeLabels, relationshipTypes);
        return this.computeLinkFeatures(graphName, nodeLabels, relationshipTypes);
    }

    private HugeObjectArray<double[]> computeLinkFeatures(String graphName, Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes) {
        Graph graph = GraphStoreCatalog.get((String)this.userName, (NamedDatabaseId)this.databaseId, (String)graphName).graphStore().getGraph(nodeLabels, relationshipTypes, Optional.empty());
        this.validate(graph);
        HugeObjectArray linkFeatures = HugeObjectArray.newArray(double[].class, (long)graph.relationshipCount(), (AllocationTracker)AllocationTracker.empty());
        List featureSize = this.linkFeatureSteps.stream().map(step -> step.outputFeatureSize(graph)).collect(Collectors.toList());
        int totalFeatureSize = featureSize.stream().mapToInt(Integer::intValue).sum();
        linkFeatures.setAll(i -> new double[totalFeatureSize]);
        int featureOffset = 0;
        for (int i2 = 0; i2 < this.linkFeatureSteps.size(); ++i2) {
            LinkFeatureStep step2 = this.linkFeatureSteps.get(i2);
            step2.addFeatures(graph, linkFeatures, featureOffset);
            featureOffset += ((Integer)featureSize.get(i2)).intValue();
        }
        return linkFeatures;
    }

    private void executeProcedureSteps(String graphName, Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes) {
        for (ProcedureStep step : this.procedureSteps) {
            step.execute(this.caller, graphName, nodeLabels, relationshipTypes);
        }
    }

    private void validate(Graph graph) {
        Set graphProperties = graph.availableNodeProperties();
        List invalidProperties = this.linkFeatureSteps.stream().flatMap(step -> step.inputNodeProperties().stream()).filter(property -> !graphProperties.contains(property)).collect(Collectors.toList());
        if (!invalidProperties.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node properties %s defined in the LinkFeatureSteps do not exist in the graph or part of the pipeline", (Object[])new Object[]{invalidProperties}));
        }
    }
}

