/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphalgo.core.model.Model;

public class MLTrainResult {
    public final long trainMillis;
    public final Map<String, Object> modelInfo;
    public final Map<String, Object> configuration;

    public MLTrainResult(Model<?, ?> trainedModel, long trainMillis) {
        this.modelInfo = Stream.concat(Map.of("modelName", trainedModel.name(), "modelType", trainedModel.algoType()).entrySet().stream(), trainedModel.customInfo().toMap().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.configuration = trainedModel.trainConfig().toMap();
        this.trainMillis = trainMillis;
    }
}

