/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.scc;

import java.util.Map;
import java.util.Optional;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.api.nodeproperties.LongNodeProperties;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.WritePropertyConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.SecureTransaction;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.impl.scc.SccAlgorithm;
import org.neo4j.graphalgo.impl.scc.SccConfig;
import org.neo4j.graphalgo.result.AbstractCommunityResultBuilder;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class SccProc
extends AlgoBaseProc<SccAlgorithm, HugeLongArray, SccConfig> {
    private static final String DESCRIPTION = "The SCC algorithm finds sets of connected nodes in an directed graph, where all nodes in the same set form a connected component.";

    @Procedure(value="gds.alpha.scc.write", mode=Mode.WRITE)
    @Description(value="The SCC algorithm finds sets of connected nodes in an directed graph, where all nodes in the same set form a connected component.")
    public Stream<SccResult> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        final AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        SccAlgorithm algorithm = (SccAlgorithm)computationResult.algorithm();
        final HugeLongArray components = (HugeLongArray)computationResult.result();
        SccConfig config = (SccConfig)computationResult.config();
        AllocationTracker tracker = this.allocationTracker();
        Graph graph = computationResult.graph();
        AbstractResultBuilder writeBuilder = new SccResultBuilder(this.callContext, config.concurrency(), tracker).buildCommunityCount(true).buildHistogram(true).withCommunityFunction(components != null ? arg_0 -> ((HugeLongArray)components).get(arg_0) : null).withNodeCount(graph.nodeCount()).withConfig((AlgoBaseConfig)config).withCreateMillis(computationResult.createMillis()).withComputeMillis(computationResult.computeMillis());
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of((SccResult)writeBuilder.build());
        }
        this.log.info("Scc: overall memory usage: %s", new Object[]{tracker.getUsageString()});
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((AbstractResultBuilder)writeBuilder).withWriteMillis(arg_0));){
            NodePropertyExporter exporter = (NodePropertyExporter)NodePropertyExporter.builder((SecureTransaction)SecureTransaction.of((GraphDatabaseAPI)this.api, (Transaction)this.procedureTransaction), (IdMapping)graph, (TerminationFlag)algorithm.getTerminationFlag()).withLog(this.log).parallel(Pools.DEFAULT, config.writeConcurrency()).build();
            LongNodeProperties properties = new LongNodeProperties(){

                public long size() {
                    return computationResult.graph().nodeCount();
                }

                public long longValue(long nodeId) {
                    return components.get(nodeId);
                }
            };
            exporter.write(config.writeProperty(), (NodeProperties)properties);
            writeBuilder.withNodePropertiesWritten(exporter.propertiesWritten());
        }
        graph.release();
        return Stream.of((SccResult)writeBuilder.build());
    }

    @Procedure(value="gds.alpha.scc.stream", mode=Mode.READ)
    @Description(value="The SCC algorithm finds sets of connected nodes in an directed graph, where all nodes in the same set form a connected component.")
    public Stream<SccAlgorithm.StreamResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        AllocationTracker tracker = this.allocationTracker();
        Graph graph = computationResult.graph();
        HugeLongArray components = (HugeLongArray)computationResult.result();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.empty();
        }
        this.log.info("Scc: overall memory usage: %s", new Object[]{tracker.getUsageString()});
        graph.release();
        return LongStream.range(0L, graph.nodeCount()).filter(i -> components.get(i) != -1L).mapToObj(i -> new SccAlgorithm.StreamResult(graph.toOriginalNodeId(i), components.get(i)));
    }

    protected SccConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return SccConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<SccAlgorithm, SccConfig> algorithmFactory() {
        return (graph, configuration, tracker, log, eventTracker) -> (SccAlgorithm)new SccAlgorithm(graph, tracker).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)this.transaction));
    }

    public static final class SccResultBuilder
    extends AbstractCommunityResultBuilder<SccResult> {
        SccResultBuilder(ProcedureCallContext context, int concurrency, AllocationTracker tracker) {
            super(context, concurrency, tracker);
        }

        public SccResult buildResult() {
            return new SccResult(this.createMillis, this.computeMillis, this.writeMillis, this.postProcessingDuration, this.nodeCount, this.maybeCommunityCount.orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(100.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(99.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(95.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(90.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(75.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(50.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(25.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(10.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(5.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(1.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getMinNonZeroValue()).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getMaxValue()).orElse(0L), this.config instanceof WritePropertyConfig ? ((WritePropertyConfig)this.config).writeProperty() : "");
        }

        public SccResultBuilder buildHistogram(boolean buildHistogram) {
            this.buildHistogram = buildHistogram;
            return this;
        }

        public SccResultBuilder buildCommunityCount(boolean buildCommunityCount) {
            this.buildCommunityCount = buildCommunityCount;
            return this;
        }
    }

    public static class SccResult {
        public final long createMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final long postProcessingMillis;
        public final long nodes;
        public final long communityCount;
        public final long setCount;
        public final long minSetSize;
        public final long maxSetSize;
        public final long p1;
        public final long p5;
        public final long p10;
        public final long p25;
        public final long p50;
        public final long p75;
        public final long p90;
        public final long p95;
        public final long p99;
        public final long p100;
        public final String writeProperty;

        public SccResult(long createMillis, long computeMillis, long postProcessingMillis, long writeMillis, long nodes, long communityCount, long p100, long p99, long p95, long p90, long p75, long p50, long p25, long p10, long p5, long p1, long minSetSize, long maxSetSize, String writeProperty) {
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.postProcessingMillis = postProcessingMillis;
            this.writeMillis = writeMillis;
            this.nodes = nodes;
            this.setCount = this.communityCount = communityCount;
            this.p100 = p100;
            this.p99 = p99;
            this.p95 = p95;
            this.p90 = p90;
            this.p75 = p75;
            this.p50 = p50;
            this.p25 = p25;
            this.p10 = p10;
            this.p5 = p5;
            this.p1 = p1;
            this.minSetSize = minSetSize;
            this.maxSetSize = maxSetSize;
            this.writeProperty = writeProperty;
        }
    }
}

