/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.influence\u039caximization;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.impl.influenceMaximization.Greedy;
import org.neo4j.graphalgo.influence\u039caximization.InfluenceMaximizationConfig;
import org.neo4j.graphalgo.influence\u039caximization.InfluenceMaximizationConfigImpl;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.InfluenceMaximizationResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GreedyProc
extends AlgoBaseProc<Greedy, Greedy, InfluenceMaximizationConfig> {
    private static final String DESCRIPTION = "The Greedy algorithm aims to find k nodes that maximize the expected spread of influence in the network.";

    @Procedure(name="gds.alpha.influenceMaximization.greedy.stream", mode=Mode.READ)
    @Description(value="The Greedy algorithm aims to find k nodes that maximize the expected spread of influence in the network.")
    public Stream<InfluenceMaximizationResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        if (computationResult.graph().isEmpty()) {
            computationResult.graph().release();
            return Stream.empty();
        }
        computationResult.graph().release();
        return ((Greedy)computationResult.algorithm()).resultStream();
    }

    @Description(value="The Greedy algorithm aims to find k nodes that maximize the expected spread of influence in the network.")
    public Stream<InfluenceMaximizationResult.Stats> stats(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        InfluenceMaximizationConfig config = (InfluenceMaximizationConfig)computationResult.config();
        Graph graph = computationResult.graph();
        AbstractResultBuilder builder = new InfluenceMaximizationResult.Stats.Builder().withNodeCount(graph.nodeCount()).withConfig((AlgoBaseConfig)config).withComputeMillis(computationResult.computeMillis());
        return Stream.of((InfluenceMaximizationResult.Stats)builder.build());
    }

    protected InfluenceMaximizationConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return new InfluenceMaximizationConfigImpl(graphName, maybeImplicitCreate, username, config);
    }

    protected AlgorithmFactory<Greedy, InfluenceMaximizationConfig> algorithmFactory() {
        return (graph, configuration, tracker, log, eventTracker) -> new Greedy(graph, configuration.seedSetSize(), configuration.propagationProbability(), configuration.monteCarloSimulations(), Pools.DEFAULT, configuration.concurrency(), tracker);
    }
}

