/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.centrality.AsUndirected;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.SecureTransaction;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.HugeDoubleArray;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.impl.closeness.ClosenessCentralityConfig;
import org.neo4j.graphalgo.impl.closeness.MSClosenessCentrality;
import org.neo4j.graphalgo.result.AbstractCentralityResultBuilder;
import org.neo4j.graphalgo.results.CentralityScore;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ClosenessCentralityProc
extends AlgoBaseProc<MSClosenessCentrality, MSClosenessCentrality, ClosenessCentralityConfig> {
    private static final String DESCRIPTION = "Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.";

    @Procedure(name="gds.alpha.closeness.stream", mode=Mode.READ)
    @Description(value="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<MSClosenessCentrality.Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        MSClosenessCentrality algorithm = (MSClosenessCentrality)computationResult.algorithm();
        Graph graph = computationResult.graph();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.empty();
        }
        graph.release();
        return algorithm.resultStream();
    }

    @Procedure(value="gds.alpha.closeness.write", mode=Mode.WRITE)
    @Description(value="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<CentralityScore.Stats> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        MSClosenessCentrality algorithm = (MSClosenessCentrality)computationResult.algorithm();
        ClosenessCentralityConfig config = (ClosenessCentralityConfig)computationResult.config();
        Graph graph = computationResult.graph();
        CentralityScore.Stats.Builder builder = new CentralityScore.Stats.Builder(this.callContext, config.concurrency());
        builder.withNodeCount(graph.nodeCount()).withConfig((AlgoBaseConfig)config).withComputeMillis(computationResult.computeMillis()).withCreateMillis(computationResult.createMillis());
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of((CentralityScore.Stats)builder.build());
        }
        builder.withCentralityFunction(arg_0 -> ((HugeDoubleArray)algorithm.getCentrality()).get(arg_0));
        try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((AbstractCentralityResultBuilder)builder).withWriteMillis(arg_0));){
            NodePropertyExporter exporter = (NodePropertyExporter)NodePropertyExporter.builder((SecureTransaction)SecureTransaction.of((GraphDatabaseAPI)this.api, (Transaction)this.procedureTransaction), (IdMapping)graph, (TerminationFlag)algorithm.getTerminationFlag()).withLog(this.log).parallel(Pools.DEFAULT, ((ClosenessCentralityConfig)computationResult.config()).writeConcurrency()).build();
            algorithm.export(config.writeProperty(), exporter);
        }
        graph.release();
        return Stream.of((CentralityScore.Stats)builder.build());
    }

    protected ClosenessCentralityConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ClosenessCentralityConfig.of(graphName, maybeImplicitCreate.map(AsUndirected::rewrite), (String)username, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<MSClosenessCentrality, ClosenessCentralityConfig> algorithmFactory() {
        return (graph, configuration, tracker, log, eventTracker) -> new MSClosenessCentrality(graph, tracker, configuration.concurrency(), Pools.DEFAULT, configuration.improved());
    }
}

