/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.ml.nodemodels.NodeClassificationMutateConfig;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredict;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.NodeClassificationTrainConfig;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionData;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionResult;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.MutatePropertyProc;
import org.neo4j.graphalgo.api.GraphStore;
import org.neo4j.graphalgo.api.GraphStoreValidation;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.api.nodeproperties.DoubleArrayNodeProperties;
import org.neo4j.graphalgo.api.nodeproperties.LongNodeProperties;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.model.ModelCatalog;
import org.neo4j.graphalgo.core.utils.paged.HugeObjectArray;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.graphalgo.results.StandardMutateResult;
import org.neo4j.graphalgo.utils.StringFormatting;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPredictMutateProc
extends MutatePropertyProc<NodeClassificationPredict, NodeLogisticRegressionResult, MutateResult, NodeClassificationMutateConfig> {
    @Procedure(name="gds.alpha.ml.nodeClassification.predict.mutate", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<MutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult result = this.compute(graphNameOrConfig, configuration);
        return this.mutate(result);
    }

    @Procedure(name="gds.alpha.ml.nodeClassification.predict.mutate.estimate", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(AlgoBaseProc.ComputationResult<NodeClassificationPredict, NodeLogisticRegressionResult, NodeClassificationMutateConfig> computeResult) {
        return new MutateResult.Builder();
    }

    protected void validateConfigsAfterLoad(GraphStore graphStore, GraphCreateConfig graphCreateConfig, NodeClassificationMutateConfig config) {
        super.validateConfigsAfterLoad(graphStore, graphCreateConfig, (AlgoBaseConfig)config);
        config.predictedProbabilityProperty().ifPresent(predictedProbabilityProperty -> {
            if (config.mutateProperty().equals(predictedProbabilityProperty)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Configuration parameters `%s` and `%s` must be different (both were `%s`)", (Object[])new Object[]{"mutateProperty", "predictedProbabilityProperty", predictedProbabilityProperty}));
            }
        });
        NodeClassificationTrainConfig trainConfig = (NodeClassificationTrainConfig)ModelCatalog.get((String)config.username(), (String)config.modelName(), NodeLogisticRegressionData.class, NodeClassificationTrainConfig.class).trainConfig();
        GraphStoreValidation.validate((GraphStore)graphStore, (AlgoBaseConfig)trainConfig);
    }

    protected NodeClassificationMutateConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return NodeClassificationMutateConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<NodeClassificationPredict, NodeClassificationMutateConfig> algorithmFactory() {
        return new NodeClassificationPredictAlgorithmFactory();
    }

    protected List<NodePropertyExporter.NodeProperty> nodePropertyList(final AlgoBaseProc.ComputationResult<NodeClassificationPredict, NodeLogisticRegressionResult, NodeClassificationMutateConfig> computationResult) {
        NodeClassificationMutateConfig config = (NodeClassificationMutateConfig)computationResult.config();
        String mutateProperty = config.mutateProperty();
        NodeLogisticRegressionResult result = (NodeLogisticRegressionResult)computationResult.result();
        LongNodeProperties classProperties = result.predictedClasses().asNodeProperties();
        ArrayList<NodePropertyExporter.NodeProperty> nodeProperties = new ArrayList<NodePropertyExporter.NodeProperty>();
        nodeProperties.add(NodePropertyExporter.NodeProperty.of((String)mutateProperty, (NodeProperties)classProperties));
        if (result.predictedProbabilities().isPresent()) {
            String probabilityPropertyKey = (String)config.predictedProbabilityProperty().orElseThrow();
            final HugeObjectArray probabilityProperties = (HugeObjectArray)result.predictedProbabilities().get();
            DoubleArrayNodeProperties properties = new DoubleArrayNodeProperties(){

                public long size() {
                    return computationResult.graph().nodeCount();
                }

                public double[] doubleArrayValue(long nodeId) {
                    return (double[])probabilityProperties.get(nodeId);
                }
            };
            nodeProperties.add(NodePropertyExporter.NodeProperty.of((String)probabilityPropertyKey, (NodeProperties)properties));
        }
        return nodeProperties;
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long nodePropertiesWritten;

        MutateResult(long createMillis, long computeMillis, long mutateMillis, long nodePropertiesWritten, Map<String, Object> configuration) {
            super(createMillis, computeMillis, 0L, mutateMillis, configuration);
            this.nodePropertiesWritten = nodePropertiesWritten;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.createMillis, this.computeMillis, this.mutateMillis, this.nodePropertiesWritten, this.config.toMap());
            }
        }
    }
}

