/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredict;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictWriteConfig;
import org.neo4j.gds.ml.nodemodels.multiclasslogisticregression.MultiClassNLRResult;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.WriteProc;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.api.nodeproperties.DoubleArrayNodeProperties;
import org.neo4j.graphalgo.api.nodeproperties.LongNodeProperties;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.utils.paged.HugeObjectArray;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPredictWriteProc
extends WriteProc<NodeClassificationPredict, MultiClassNLRResult, Result, NodeClassificationPredictWriteConfig> {
    @Procedure(name="gds.alpha.ml.nodeClassification.predict.write", mode=Mode.WRITE)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<Result> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult result = this.compute(graphNameOrConfig, configuration);
        return this.write(result);
    }

    protected List<NodePropertyExporter.NodeProperty> nodePropertyList(AlgoBaseProc.ComputationResult<NodeClassificationPredict, MultiClassNLRResult, NodeClassificationPredictWriteConfig> computationResult) {
        NodeClassificationPredictWriteConfig config = (NodeClassificationPredictWriteConfig)computationResult.config();
        String writeProperty = config.writeProperty();
        MultiClassNLRResult result = (MultiClassNLRResult)computationResult.result();
        LongNodeProperties classProperties = result.predictedClasses().asNodeProperties();
        ArrayList<NodePropertyExporter.NodeProperty> nodeProperties = new ArrayList<NodePropertyExporter.NodeProperty>();
        nodeProperties.add(NodePropertyExporter.NodeProperty.of((String)writeProperty, (NodeProperties)classProperties));
        if (result.predictedProbabilities().isPresent()) {
            String probabilityPropertyKey = (String)config.predictedProbabilityProperty().orElseThrow();
            HugeObjectArray probabilityProperties = (HugeObjectArray)result.predictedProbabilities().get();
            nodeProperties.add(NodePropertyExporter.NodeProperty.of((String)probabilityPropertyKey, (NodeProperties)((DoubleArrayNodeProperties)arg_0 -> ((HugeObjectArray)probabilityProperties).get(arg_0))));
        }
        return nodeProperties;
    }

    protected NodeClassificationPredictWriteConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return NodeClassificationPredictWriteConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<NodeClassificationPredict, NodeClassificationPredictWriteConfig> algorithmFactory() {
        return new NodeClassificationPredictAlgorithmFactory();
    }

    protected AbstractResultBuilder<Result> resultBuilder(AlgoBaseProc.ComputationResult<NodeClassificationPredict, MultiClassNLRResult, NodeClassificationPredictWriteConfig> computeResult) {
        return new Result.Builder();
    }

    public static class Result {
        public final long writeMillis;
        public final long nodePropertiesWritten;
        public final long createMillis;
        public final long computeMillis;
        public final Map<String, Object> configuration;

        public Result(long createMillis, long computeMillis, long writeMillis, long nodePropertiesWritten, Map<String, Object> configuration) {
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.configuration = configuration;
        }

        static class Builder
        extends AbstractResultBuilder<Result> {
            Builder() {
            }

            public Result build() {
                return new Result(this.createMillis, this.computeMillis, this.writeMillis, this.nodePropertiesWritten, this.config.toMap());
            }
        }
    }
}

